/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.junitlambda;

import com.github.marschall.junitlambda.Block;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class ThrowsException<T extends Throwable>
extends TypeSafeMatcher<Block> {
    private static final MethodHandle CATCH_EXCEPTION;
    private static final MethodHandle CALL_PROTECTED;
    private final Matcher<T> exceptionMatcher;
    private final Class<T> expected;

    private ThrowsException(Class<T> expected, Matcher<T> exceptionMatcher) {
        this.expected = expected;
        this.exceptionMatcher = exceptionMatcher;
    }

    @Factory
    public static <T extends Throwable> Matcher<Block> throwsException(Class<T> expected) {
        return new ThrowsException<T>(expected, null);
    }

    @Factory
    public static <T extends Throwable> TypeSafeMatcher<Block> throwsException(Class<T> expected, Matcher<T> exceptionMatcher) {
        return new ThrowsException<T>(expected, exceptionMatcher);
    }

    public void describeTo(Description description) {
        description.appendText("throws exception");
        description.appendValue(this.expected);
        if (this.exceptionMatcher != null) {
            description.appendText("matching");
            description.appendDescriptionOf(this.exceptionMatcher);
        }
    }

    protected boolean matchesSafely(Block block) {
        MethodHandle call = MethodHandles.insertArguments(CALL_PROTECTED, 0, new Object[]{this, block});
        MethodHandle catchException = MethodHandles.insertArguments(CATCH_EXCEPTION, 0, new Object[]{this});
        MethodHandle verification = MethodHandles.catchException(call, this.expected, catchException);
        try {
            return (Boolean)verification.invokeWithArguments(new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean callProtected(Block block) throws Exception {
        block.value();
        return false;
    }

    private boolean catchException(Throwable exception) {
        if (this.exceptionMatcher != null) {
            return this.exceptionMatcher.matches((Object)exception);
        }
        return true;
    }

    static {
        try {
            Class<ThrowsException> refc;
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<ThrowsException> specialCaller = refc = ThrowsException.class;
            CATCH_EXCEPTION = lookup.findSpecial(refc, "catchException", MethodType.methodType(Boolean.TYPE, Throwable.class), specialCaller);
            CALL_PROTECTED = lookup.findSpecial(refc, "callProtected", MethodType.methodType(Boolean.TYPE, Block.class), specialCaller);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("could not initialize LambdaAssert", e);
        }
    }
}

