/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataColumn;
import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.DataTableException;
import com.github.martincooper.datatable.Guard;
import com.github.martincooper.datatable.IDataColumn;
import com.github.martincooper.datatable.VectorExtensions;
import io.vavr.control.Try;

public class DataRow {
    private final DataTable table;
    private final Integer rowIdx;

    private DataRow(DataTable table, Integer rowIdx) {
        this.table = table;
        this.rowIdx = rowIdx;
    }

    public DataTable table() {
        return this.table;
    }

    public Integer rowIdx() {
        return this.rowIdx;
    }

    public Object[] data() {
        return this.table.columns().map(col -> col.data().get(this.rowIdx.intValue())).toJavaArray();
    }

    public Try<Object> get(Integer colIndex) {
        return this.columnToValue(this.table.columns().tryGet(colIndex));
    }

    public Try<Object> get(String colName) {
        return this.columnToValue(this.table.columns().tryGet(colName));
    }

    public <T> T getAs(Class<T> type, Integer idx) {
        Try<DataColumn<T>> col = this.table.columns().get(idx).asType(type);
        return ((DataColumn)col.get()).valueAt(this.rowIdx);
    }

    public <T> T getAs(Class<T> type, String colName) {
        Try<DataColumn<T>> col = this.table.columns().get(colName).asType(type);
        return ((DataColumn)col.get()).valueAt(this.rowIdx);
    }

    public <T> Try<T> tryGetAs(Class<T> type, Integer idx) {
        Try col = this.table.columns().tryGet(idx).flatMap(c -> c.asType(type));
        return col.isFailure() ? Try.failure((Throwable)col.getCause()) : Try.success(((DataColumn)col.get()).valueAt(this.rowIdx));
    }

    public <T> Try<T> tryGetAs(Class<T> type, String colName) {
        Try col = this.table.columns().tryGet(colName).flatMap(c -> c.asType(type));
        return col.isFailure() ? Try.failure((Throwable)col.getCause()) : Try.success(((DataColumn)col.get()).valueAt(this.rowIdx));
    }

    private Try<Object> columnToValue(Try<IDataColumn> column) {
        return column.isSuccess() ? Try.success((Object)((IDataColumn)column.get()).valueAt(this.rowIdx)) : Try.failure((Throwable)column.getCause());
    }

    public static Try<DataRow> build(DataTable table, Integer rowIdx) {
        Guard.notNull(table, "table");
        return VectorExtensions.outOfBounds(table.rowCount(), rowIdx) ? DataTableException.tryError("Invalid row index for DataRow.") : Try.success((Object)new DataRow(table, rowIdx));
    }
}

