/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataRow;
import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.DataTableException;
import com.github.martincooper.datatable.DataView;
import com.github.martincooper.datatable.TransformCollector;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import io.vavr.control.Try;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class DataRowCollectionBase
implements Iterable<DataRow> {
    protected final DataTable table;
    protected final Vector<DataRow> rows;

    DataRowCollectionBase(DataTable table, Iterable<DataRow> rows) {
        this.table = table;
        this.rows = Vector.ofAll(rows);
    }

    @Override
    public Iterator<DataRow> iterator() {
        return this.rows.iterator();
    }

    public DataRow get(Integer rowIndex) {
        return (DataRow)this.rows.get(rowIndex.intValue());
    }

    public Integer rowCount() {
        return this.rows.length();
    }

    public Seq<DataRow> asSeq() {
        return this.rows;
    }

    public DataView filter(Predicate<DataRow> predicate) {
        return (DataView)this.rows.filter(predicate).collect(TransformCollector.transform(rows -> (DataView)DataView.build(this.table, (Iterable<DataRow>)rows).get()));
    }

    public <U> Seq<U> map(Function<? super DataRow, ? extends U> mapper) {
        return this.rows.map(mapper);
    }

    static <T extends DataRowCollectionBase> T buildRowCollection(DataTable table, BiFunction<DataTable, Iterable<DataRow>, T> builder) {
        return (T)((DataRowCollectionBase)Stream.range((int)0, (int)table.rowCount()).map(idx -> (DataRow)DataRow.build(table, idx).get()).collect(TransformCollector.transform(rows -> (DataRowCollectionBase)builder.apply(table, (Iterable<DataRow>)rows))));
    }

    static <T extends DataRowCollectionBase> Try<T> buildRowCollection(DataTable table, Iterable<DataRow> rows, BiFunction<DataTable, Iterable<DataRow>, T> builder) {
        return DataRowCollectionBase.validateDataRows(table, rows).flatMap(x -> Try.success(builder.apply(table, rows)));
    }

    private static Try<Void> validateDataRows(DataTable table, Iterable<DataRow> dataRows) {
        return List.ofAll(dataRows).forAll(row -> row.table() == table) ? Try.success(null) : DataTableException.tryError("DataRows do not all belong to the specified table.");
    }
}

