/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataColumn;
import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.IDataColumn;
import io.vavr.collection.List;
import io.vavr.control.Try;

public class DataTableBuilder {
    private final String tableName;
    private List<IDataColumn> dataColumns;

    private DataTableBuilder(String tableName) {
        this.tableName = tableName;
        this.dataColumns = List.empty();
    }

    public static DataTableBuilder create(String tableName) {
        return new DataTableBuilder(tableName);
    }

    public <T> DataTableBuilder withColumn(Class<T> type, String columnName, Iterable<T> data) {
        this.dataColumns = this.dataColumns.append(new DataColumn<T>(type, columnName, data));
        return this;
    }

    @SafeVarargs
    public final <T> DataTableBuilder withColumn(Class<T> type, String columnName, T ... data) {
        this.dataColumns = this.dataColumns.append(new DataColumn<T>(type, columnName, data));
        return this;
    }

    public Try<DataTable> build() {
        return DataTable.build(this.tableName, this.dataColumns);
    }
}

