/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable.sorting;

import com.github.martincooper.datatable.DataRow;
import com.github.martincooper.datatable.sorting.ColumnIdentity;
import com.github.martincooper.datatable.sorting.SortItem;
import com.github.martincooper.datatable.sorting.SortOrder;
import io.vavr.collection.Seq;
import java.util.Comparator;

public class DataRowComparator
implements Comparator<DataRow> {
    private final Seq<SortItem> sortItems;

    DataRowComparator(Seq<SortItem> sortItems) {
        this.sortItems = sortItems;
    }

    @Override
    public int compare(DataRow rowOne, DataRow rowTwo) {
        return DataRowComparator.compareBySortItem(rowOne, rowTwo, this.sortItems);
    }

    private static int compareBySortItem(DataRow rowOne, DataRow rowTwo, Seq<SortItem> sortItems) {
        if (sortItems.isEmpty()) {
            return 0;
        }
        Integer compareResult = DataRowComparator.compareValues(rowOne, rowTwo, (SortItem)sortItems.head());
        return compareResult == 0 ? DataRowComparator.compareBySortItem(rowOne, rowTwo, (Seq<SortItem>)sortItems.tail()) : compareResult;
    }

    private static int compareValues(DataRow rowOne, DataRow rowTwo, SortItem sortItem) {
        Object valueOne = DataRowComparator.valueFromIdentity(rowOne, sortItem.columnIdentity());
        Object valueTwo = DataRowComparator.valueFromIdentity(rowTwo, sortItem.columnIdentity());
        return sortItem.sortOrder() == SortOrder.Ascending ? DataRowComparator.compareValues(valueOne, valueTwo) : DataRowComparator.compareValues(valueTwo, valueOne);
    }

    private static Object valueFromIdentity(DataRow dataRow, ColumnIdentity columnIdentity) {
        return columnIdentity.getCellData(dataRow).get();
    }

    private static int compareValues(Object valueOne, Object valueTwo) {
        return valueOne == null ? (valueTwo == null ? 0 : Integer.MIN_VALUE) : (valueTwo == null ? Integer.MAX_VALUE : ((Comparable)valueOne).compareTo(valueTwo));
    }
}

