/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable.sorting;

import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.Guard;
import com.github.martincooper.datatable.IDataColumn;
import com.github.martincooper.datatable.sorting.ColumnIdentity;
import com.github.martincooper.datatable.sorting.SortOrder;
import io.vavr.control.Try;

public final class SortItem {
    private final ColumnIdentity columnIdentity;
    private final SortOrder sortOrder;

    public SortItem(String columnName) {
        this(new ColumnIdentity(columnName), SortOrder.Ascending);
    }

    public SortItem(String columnName, SortOrder sortOrder) {
        this(new ColumnIdentity(columnName), sortOrder);
    }

    public SortItem(Integer columnIndex) {
        this(new ColumnIdentity(columnIndex), SortOrder.Ascending);
    }

    public SortItem(Integer columnIndex, SortOrder sortOrder) {
        this(new ColumnIdentity(columnIndex), sortOrder);
    }

    private SortItem(ColumnIdentity columnIdentity, SortOrder sortOrder) {
        Guard.notNull(columnIdentity, "columnIdentity");
        Guard.notNull((Object)sortOrder, "sortOrder");
        this.columnIdentity = columnIdentity;
        this.sortOrder = sortOrder;
    }

    public SortOrder sortOrder() {
        return this.sortOrder;
    }

    public ColumnIdentity columnIdentity() {
        return this.columnIdentity;
    }

    public Try<IDataColumn> getColumn(DataTable table) {
        return this.columnIdentity.getColumn(table);
    }
}

