/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.DataTableException;
import com.github.martincooper.datatable.Guard;
import com.github.martincooper.datatable.IDataColumn;
import com.github.martincooper.datatable.IModifiableByColumn;
import com.github.martincooper.datatable.VectorExtensions;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Vector;
import io.vavr.control.Try;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;

public class DataColumnCollection
implements IModifiableByColumn<DataTable>,
Iterable<IDataColumn> {
    private final DataTable table;
    private final Vector<IDataColumn> columns;

    DataColumnCollection(DataTable table) {
        this(table, (Iterable<IDataColumn>)List.empty());
    }

    DataColumnCollection(DataTable table, Iterable<IDataColumn> columns) {
        Guard.notNull(table, "table");
        Guard.itemsNotNull(columns, "columns");
        this.table = table;
        this.columns = Vector.ofAll(columns);
    }

    @Override
    public Iterator<IDataColumn> iterator() {
        return this.columns.iterator();
    }

    public <U> Seq<U> map(Function<? super IDataColumn, ? extends U> mapper) {
        return this.columns.map(mapper);
    }

    public Try<IDataColumn> tryGet(int index) {
        return VectorExtensions.outOfBounds(this.columns, (Integer)index) ? DataTableException.tryError("Column index out of bounds") : Try.success((Object)this.get(index));
    }

    public IDataColumn get(int index) {
        return (IDataColumn)this.columns.get(index);
    }

    public Try<IDataColumn> tryGet(String columnName) {
        Integer idx = this.columnIdxByName(columnName);
        return idx < 0 ? DataTableException.tryError("Invalid column name.") : Try.success((Object)this.get(idx));
    }

    public IDataColumn get(String columnName) {
        return (IDataColumn)this.columns.get(this.columnIdxByName(columnName).intValue());
    }

    public int count() {
        return this.columns.length();
    }

    @Override
    public Try<DataTable> add(IDataColumn newColumn) {
        return this.checkColumnsAndBuild("adding", () -> VectorExtensions.addItem(this.columns, newColumn));
    }

    @Override
    public Try<DataTable> replace(Integer index, IDataColumn newColumn) {
        return this.checkColumnsAndBuild("replacing", () -> VectorExtensions.replaceItem(this.columns, index, newColumn));
    }

    @Override
    public Try<DataTable> insert(Integer index, IDataColumn newColumn) {
        return this.checkColumnsAndBuild("inserting", () -> VectorExtensions.insertItem(this.columns, index, newColumn));
    }

    @Override
    public Try<DataTable> remove(Integer index) {
        return this.checkColumnsAndBuild("removing", () -> VectorExtensions.removeItem(this.columns, index));
    }

    @Override
    public Try<DataTable> replace(String columnName, IDataColumn newColumn) {
        return this.actionByColumnName(columnName, colIdx -> this.replace((Integer)colIdx, newColumn));
    }

    @Override
    public Try<DataTable> insert(String columnName, IDataColumn newColumn) {
        return this.actionByColumnName(columnName, colIdx -> this.insert((Integer)colIdx, newColumn));
    }

    @Override
    public Try<DataTable> remove(String columnName) {
        return this.actionByColumnName(columnName, this::remove);
    }

    @Override
    public Try<DataTable> replace(IDataColumn oldColumn, IDataColumn newColumn) {
        return this.replace(this.columns.indexOf((Object)oldColumn), newColumn);
    }

    @Override
    public Try<DataTable> insert(IDataColumn currentColumn, IDataColumn newColumn) {
        return this.insert(this.columns.indexOf((Object)currentColumn), newColumn);
    }

    @Override
    public Try<DataTable> remove(IDataColumn columnToRemove) {
        return this.remove(this.columns.indexOf((Object)columnToRemove));
    }

    private Try<DataTable> actionByColumnName(String columnName, Function<Integer, Try<DataTable>> action) {
        Integer idx = this.columnIdxByName(columnName);
        return idx < 0 ? DataColumnCollection.error("Column not found with name " + columnName) : action.apply(idx);
    }

    private Integer columnIdxByName(String columnName) {
        return this.columns.indexWhere(col -> DataColumnCollection.compare(col.name(), columnName));
    }

    private Try<DataTable> checkColumnsAndBuild(String changeType, Supplier<Try<Vector<IDataColumn>>> columns) {
        Try<DataTable> result = columns.get().flatMap(cols -> DataTable.build(this.table.name(), (Iterable<IDataColumn>)cols));
        return result.isSuccess() ? result : DataColumnCollection.error("Error " + changeType + " column at specified index.", result.getCause());
    }

    private static Try<DataTable> error(String errorMessage) {
        return DataTableException.tryError(errorMessage);
    }

    private static Try<DataTable> error(String errorMessage, Throwable exception) {
        return DataTableException.tryError(errorMessage, exception);
    }

    private static boolean compare(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }
}

