/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable.sorting;

import com.github.martincooper.datatable.DataColumnCollection;
import com.github.martincooper.datatable.DataRow;
import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.IDataColumn;
import io.vavr.control.Try;
import java.util.function.Function;

final class ColumnIdentity {
    private final Function<DataColumnCollection, Try<IDataColumn>> getColumn;

    ColumnIdentity(String columnName) {
        this.getColumn = cols -> cols.tryGet(columnName);
    }

    ColumnIdentity(Integer columnIndex) {
        this.getColumn = cols -> cols.tryGet(columnIndex);
    }

    Try<IDataColumn> getColumn(DataTable table) {
        return this.getColumn.apply(table.columns());
    }

    Try<Object> getCellData(DataRow dataRow) {
        return this.getColumn.apply(dataRow.table().columns()).flatMap(col -> Try.success((Object)col.valueAt(dataRow.rowIdx())));
    }
}

