/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.agcod;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.agcod.model.AgcodException;
import software.amazon.awssdk.services.agcod.model.CancelGiftCardRequest;
import software.amazon.awssdk.services.agcod.model.CancelGiftCardResponse;
import software.amazon.awssdk.services.agcod.model.CreateGiftCardRequest;
import software.amazon.awssdk.services.agcod.model.CreateGiftCardResponse;
import software.amazon.awssdk.services.agcod.model.GetAvailableFundsRequest;
import software.amazon.awssdk.services.agcod.model.GetAvailableFundsResponse;
import software.amazon.awssdk.services.agcod.model.InternalServerErrorException;
import software.amazon.awssdk.services.agcod.model.PartnerAccessErrorException;
import software.amazon.awssdk.services.agcod.model.PartnerInputErrorException;
import software.amazon.awssdk.services.agcod.model.ResendErrorException;
import software.amazon.awssdk.services.agcod.model.SystemErrorException;
import software.amazon.awssdk.services.agcod.model.UnknownErrorException;
import software.amazon.awssdk.services.agcod.transform.CancelGiftCardRequestMarshaller;
import software.amazon.awssdk.services.agcod.transform.CreateGiftCardRequestMarshaller;
import software.amazon.awssdk.services.agcod.transform.GetAvailableFundsRequestMarshaller;

/**
 * Internal implementation of {@link AgcodClient}.
 *
 * @see AgcodClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAgcodClient implements AgcodClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAgcodClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * The <code>CancelGiftCardRequest</code> request cancels the Gift Card. This operation can only be executed within
     * 15 minutes of the creation request time stamp
     * </p>
     *
     * @param cancelGiftCardRequest
     *        Represents the input of a <code>CancelGiftCardRequest</code> operation.
     * @return Result of the CancelGiftCard operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SystemErrorException
     *         F100: System Errors
     * @throws PartnerInputErrorException
     *         F200: Partner Input Errors
     * @throws PartnerAccessErrorException
     *         F300: Partner Account/Access/Onboarding Errors
     * @throws ResendErrorException
     *         F400: RESEND Errors
     * @throws UnknownErrorException
     *         F500: Unknown Errors
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AgcodException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AgcodClient.CancelGiftCard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/agcod-2019-11-29/CancelGiftCard" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelGiftCardResponse cancelGiftCard(CancelGiftCardRequest cancelGiftCardRequest)
            throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException,
            ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelGiftCardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelGiftCardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CancelGiftCardRequest, CancelGiftCardResponse>()
                .withOperationName("CancelGiftCard").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(cancelGiftCardRequest)
                .withMarshaller(new CancelGiftCardRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * The <code>CreateGiftCardRequest</code> requests creates a Amazon Gift Card
     * </p>
     *
     * @param createGiftCardRequest
     *        Represents the input of a <code>CreateGiftCardRequest</code> operation.
     * @return Result of the CreateGiftCard operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SystemErrorException
     *         F100: System Errors
     * @throws PartnerInputErrorException
     *         F200: Partner Input Errors
     * @throws PartnerAccessErrorException
     *         F300: Partner Account/Access/Onboarding Errors
     * @throws ResendErrorException
     *         F400: RESEND Errors
     * @throws UnknownErrorException
     *         F500: Unknown Errors
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AgcodException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AgcodClient.CreateGiftCard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/agcod-2019-11-29/CreateGiftCard" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGiftCardResponse createGiftCard(CreateGiftCardRequest createGiftCardRequest)
            throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException,
            ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGiftCardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGiftCardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateGiftCardRequest, CreateGiftCardResponse>()
                .withOperationName("CreateGiftCard").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createGiftCardRequest)
                .withMarshaller(new CreateGiftCardRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * The <code>GetAvailableFundsRequest</code> returns the amount of funds currently available in your Amazon
     * Incentives account. It provides an alternative to logging into our portal for viewing available funds. A
     * potential use-case of this operation is to develop a customized alerting system or checking the balance of an
     * account periodically.
     * </p>
     *
     * @param getAvailableFundsRequest
     *        Represents the input of a <code>GetAvailableFundsRequest</code> operation.
     * @return Result of the GetAvailableFunds operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SystemErrorException
     *         F100: System Errors
     * @throws PartnerInputErrorException
     *         F200: Partner Input Errors
     * @throws PartnerAccessErrorException
     *         F300: Partner Account/Access/Onboarding Errors
     * @throws ResendErrorException
     *         F400: RESEND Errors
     * @throws UnknownErrorException
     *         F500: Unknown Errors
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AgcodException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AgcodClient.GetAvailableFunds
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/agcod-2019-11-29/GetAvailableFunds" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAvailableFundsResponse getAvailableFunds(GetAvailableFundsRequest getAvailableFundsRequest)
            throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException,
            ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAvailableFundsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAvailableFundsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetAvailableFundsRequest, GetAvailableFundsResponse>()
                .withOperationName("GetAvailableFunds").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getAvailableFundsRequest)
                .withMarshaller(new GetAvailableFundsRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AgcodException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .customErrorCodeFieldName("errorCode")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("F100").exceptionBuilderSupplier(SystemErrorException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("F200")
                                .exceptionBuilderSupplier(PartnerInputErrorException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("F300")
                                .exceptionBuilderSupplier(PartnerAccessErrorException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("F500").exceptionBuilderSupplier(UnknownErrorException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("F400").exceptionBuilderSupplier(ResendErrorException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerError")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
