package software.amazon.awssdk.services.agcod.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpRequest;

import java.text.SimpleDateFormat;
import java.util.Locale;

@SdkInternalApi
public final class AcceptJsonInterceptor implements ExecutionInterceptor {
    private static final SimpleDateFormat asctimeFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
    public static final ExecutionAttribute<String> gcExpirationDateAttribute = new ExecutionAttribute<>("gcExpirationDate");

    @Override
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        return context.httpRequest()
                .toBuilder()
                .putHeader("Accept", "application/json")
                .putHeader("Content-Type", "application/json")
                .build();
    }

//    @Override
//    public void modifyHttpRespnseContent(Context.BeforeUnmarshalling context, ExecutionAttributes executionAttributes) {
//        try {
//            String dateUnformatted = executionAttributes.getAttribute(gcExpirationDateAttribute);
//            Date date = asctimeFormat.parse(dateUnformatted);
//            long unixDateTime = date.getTime() / 1000;
//            executionAttributes.putAttribute(gcExpirationDateAttribute, Long.toString(unixDateTime));
//        } catch (Exception ignored) {
//        }
//    }

//    @Override
//    public Optional<InputStream> modifyHttpResponseContent(Context.ModifyHttpResponse context,
//                                                           ExecutionAttributes executionAttributes) {
//        try {
//            context.responseBody().get()
//
//            String dateUnformatted = executionAttributes.getAttribute(gcExpirationDateAttribute);
//            Date date = asctimeFormat.parse(dateUnformatted);
//            long unixDateTime = date.getTime() / 1000;
//            executionAttributes.putAttribute(gcExpirationDateAttribute, Long.toString(unixDateTime));
//        } catch (Exception ignored) {
//        }
//
//        return  context.responseBody();
//    }
}
