/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.agcod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.agcod.model.AgcodResponse;
import software.amazon.awssdk.services.agcod.model.AgcodResponseStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelGiftCardResponse
extends AgcodResponse
implements ToCopyableBuilder<Builder, CancelGiftCardResponse> {
    private static final SdkField<String> CREATION_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelGiftCardResponse.getter(CancelGiftCardResponse::creationRequestId)).setter(CancelGiftCardResponse.setter(Builder::creationRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationRequestId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelGiftCardResponse.getter(CancelGiftCardResponse::statusAsString)).setter(CancelGiftCardResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_REQUEST_ID_FIELD, STATUS_FIELD));
    private final String creationRequestId;
    private final String status;

    private CancelGiftCardResponse(BuilderImpl builder) {
        super(builder);
        this.creationRequestId = builder.creationRequestId;
        this.status = builder.status;
    }

    public String creationRequestId() {
        return this.creationRequestId;
    }

    public AgcodResponseStatus status() {
        return AgcodResponseStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelGiftCardResponse)) {
            return false;
        }
        CancelGiftCardResponse other = (CancelGiftCardResponse)((Object)obj);
        return Objects.equals(this.creationRequestId(), other.creationRequestId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"CancelGiftCardResponse").add("CreationRequestId", (Object)this.creationRequestId()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationRequestId": {
                return Optional.ofNullable(clazz.cast(this.creationRequestId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelGiftCardResponse, T> g) {
        return obj -> g.apply((CancelGiftCardResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AgcodResponse.BuilderImpl
    implements Builder {
        private String creationRequestId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelGiftCardResponse model) {
            super(model);
            this.creationRequestId(model.creationRequestId);
            this.status(model.status);
        }

        public final String getCreationRequestId() {
            return this.creationRequestId;
        }

        @Override
        public final Builder creationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
            return this;
        }

        public final void setCreationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgcodResponseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public CancelGiftCardResponse build() {
            return new CancelGiftCardResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AgcodResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelGiftCardResponse> {
        public Builder creationRequestId(String var1);

        public Builder status(String var1);

        public Builder status(AgcodResponseStatus var1);
    }
}

