/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.agcod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.agcod.model.AgcodRequest;
import software.amazon.awssdk.services.agcod.model.AgcodValue;
import software.amazon.awssdk.services.agcod.model.ProductType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGiftCardRequest
extends AgcodRequest
implements ToCopyableBuilder<Builder, CreateGiftCardRequest> {
    private static final SdkField<String> CREATION_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardRequest.getter(CreateGiftCardRequest::creationRequestId)).setter(CreateGiftCardRequest.setter(Builder::creationRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationRequestId").build()}).build();
    private static final SdkField<String> PARTNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardRequest.getter(CreateGiftCardRequest::partnerId)).setter(CreateGiftCardRequest.setter(Builder::partnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerId").build()}).build();
    private static final SdkField<AgcodValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateGiftCardRequest.getter(CreateGiftCardRequest::value)).setter(CreateGiftCardRequest.setter(Builder::value)).constructor(AgcodValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> PROGRAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardRequest.getter(CreateGiftCardRequest::programId)).setter(CreateGiftCardRequest.setter(Builder::programId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programId").build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardRequest.getter(CreateGiftCardRequest::productTypeAsString)).setter(CreateGiftCardRequest.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productType").build()}).build();
    private static final SdkField<String> EXTERNAL_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGiftCardRequest.getter(CreateGiftCardRequest::externalReference)).setter(CreateGiftCardRequest.setter(Builder::externalReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_REQUEST_ID_FIELD, PARTNER_ID_FIELD, VALUE_FIELD, PROGRAM_ID_FIELD, PRODUCT_TYPE_FIELD, EXTERNAL_REFERENCE_FIELD));
    private final String creationRequestId;
    private final String partnerId;
    private final AgcodValue value;
    private final String programId;
    private final String productType;
    private final String externalReference;

    private CreateGiftCardRequest(BuilderImpl builder) {
        super(builder);
        this.creationRequestId = builder.creationRequestId;
        this.partnerId = builder.partnerId;
        this.value = builder.value;
        this.programId = builder.programId;
        this.productType = builder.productType;
        this.externalReference = builder.externalReference;
    }

    public String creationRequestId() {
        return this.creationRequestId;
    }

    public String partnerId() {
        return this.partnerId;
    }

    public AgcodValue value() {
        return this.value;
    }

    public String programId() {
        return this.programId;
    }

    public ProductType productType() {
        return ProductType.fromValue(this.productType);
    }

    public String productTypeAsString() {
        return this.productType;
    }

    public String externalReference() {
        return this.externalReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.programId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalReference());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGiftCardRequest)) {
            return false;
        }
        CreateGiftCardRequest other = (CreateGiftCardRequest)((Object)obj);
        return Objects.equals(this.creationRequestId(), other.creationRequestId()) && Objects.equals(this.partnerId(), other.partnerId()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.programId(), other.programId()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString()) && Objects.equals(this.externalReference(), other.externalReference());
    }

    public String toString() {
        return ToString.builder((String)"CreateGiftCardRequest").add("CreationRequestId", (Object)this.creationRequestId()).add("PartnerId", (Object)this.partnerId()).add("Value", (Object)this.value()).add("ProgramId", (Object)this.programId()).add("ProductType", (Object)this.productTypeAsString()).add("ExternalReference", (Object)this.externalReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationRequestId": {
                return Optional.ofNullable(clazz.cast(this.creationRequestId()));
            }
            case "partnerId": {
                return Optional.ofNullable(clazz.cast(this.partnerId()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "programId": {
                return Optional.ofNullable(clazz.cast(this.programId()));
            }
            case "productType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
            case "externalReference": {
                return Optional.ofNullable(clazz.cast(this.externalReference()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGiftCardRequest, T> g) {
        return obj -> g.apply((CreateGiftCardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AgcodRequest.BuilderImpl
    implements Builder {
        private String creationRequestId;
        private String partnerId;
        private AgcodValue value;
        private String programId;
        private String productType;
        private String externalReference;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGiftCardRequest model) {
            super(model);
            this.creationRequestId(model.creationRequestId);
            this.partnerId(model.partnerId);
            this.value(model.value);
            this.programId(model.programId);
            this.productType(model.productType);
            this.externalReference(model.externalReference);
        }

        public final String getCreationRequestId() {
            return this.creationRequestId;
        }

        @Override
        public final Builder creationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
            return this;
        }

        public final void setCreationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
        }

        public final String getPartnerId() {
            return this.partnerId;
        }

        @Override
        public final Builder partnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        public final void setPartnerId(String partnerId) {
            this.partnerId = partnerId;
        }

        public final AgcodValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(AgcodValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(AgcodValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final String getProgramId() {
            return this.programId;
        }

        @Override
        public final Builder programId(String programId) {
            this.programId = programId;
            return this;
        }

        public final void setProgramId(String programId) {
            this.programId = programId;
        }

        public final String getProductTypeAsString() {
            return this.productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(ProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public final String getExternalReference() {
            return this.externalReference;
        }

        @Override
        public final Builder externalReference(String externalReference) {
            this.externalReference = externalReference;
            return this;
        }

        public final void setExternalReference(String externalReference) {
            this.externalReference = externalReference;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGiftCardRequest build() {
            return new CreateGiftCardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AgcodRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGiftCardRequest> {
        public Builder creationRequestId(String var1);

        public Builder partnerId(String var1);

        public Builder value(AgcodValue var1);

        default public Builder value(Consumer<AgcodValue.Builder> value) {
            return this.value((AgcodValue)((AgcodValue.Builder)AgcodValue.builder().applyMutation(value)).build());
        }

        public Builder programId(String var1);

        public Builder productType(String var1);

        public Builder productType(ProductType var1);

        public Builder externalReference(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

