/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.agcod.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.agcod.model.AgcodResponse;
import software.amazon.awssdk.services.agcod.model.AgcodResponseStatus;
import software.amazon.awssdk.services.agcod.model.AgcodValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAvailableFundsResponse
extends AgcodResponse
implements ToCopyableBuilder<Builder, GetAvailableFundsResponse> {
    private static final SdkField<AgcodValue> AVAILABLE_FUNDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetAvailableFundsResponse.getter(GetAvailableFundsResponse::availableFunds)).setter(GetAvailableFundsResponse.setter(Builder::availableFunds)).constructor(AgcodValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableFunds").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetAvailableFundsResponse.getter(GetAvailableFundsResponse::timestamp)).setter(GetAvailableFundsResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAvailableFundsResponse.getter(GetAvailableFundsResponse::statusAsString)).setter(GetAvailableFundsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_FUNDS_FIELD, TIMESTAMP_FIELD, STATUS_FIELD));
    private final AgcodValue availableFunds;
    private final Instant timestamp;
    private final String status;

    private GetAvailableFundsResponse(BuilderImpl builder) {
        super(builder);
        this.availableFunds = builder.availableFunds;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
    }

    public AgcodValue availableFunds() {
        return this.availableFunds;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public AgcodResponseStatus status() {
        return AgcodResponseStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.availableFunds());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAvailableFundsResponse)) {
            return false;
        }
        GetAvailableFundsResponse other = (GetAvailableFundsResponse)((Object)obj);
        return Objects.equals(this.availableFunds(), other.availableFunds()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetAvailableFundsResponse").add("AvailableFunds", (Object)this.availableFunds()).add("Timestamp", (Object)this.timestamp()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "availableFunds": {
                return Optional.ofNullable(clazz.cast(this.availableFunds()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAvailableFundsResponse, T> g) {
        return obj -> g.apply((GetAvailableFundsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AgcodResponse.BuilderImpl
    implements Builder {
        private AgcodValue availableFunds;
        private Instant timestamp;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAvailableFundsResponse model) {
            super(model);
            this.availableFunds(model.availableFunds);
            this.timestamp(model.timestamp);
            this.status(model.status);
        }

        public final AgcodValue.Builder getAvailableFunds() {
            return this.availableFunds != null ? this.availableFunds.toBuilder() : null;
        }

        @Override
        public final Builder availableFunds(AgcodValue availableFunds) {
            this.availableFunds = availableFunds;
            return this;
        }

        public final void setAvailableFunds(AgcodValue.BuilderImpl availableFunds) {
            this.availableFunds = availableFunds != null ? availableFunds.build() : null;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgcodResponseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public GetAvailableFundsResponse build() {
            return new GetAvailableFundsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AgcodResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAvailableFundsResponse> {
        public Builder availableFunds(AgcodValue var1);

        default public Builder availableFunds(Consumer<AgcodValue.Builder> availableFunds) {
            return this.availableFunds((AgcodValue)((AgcodValue.Builder)AgcodValue.builder().applyMutation(availableFunds)).build());
        }

        public Builder timestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(AgcodResponseStatus var1);
    }
}

