/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.concurrent;

public abstract class AbstractSingleThreadRunner {
    public static final byte STARTED = 1;
    public static final byte STOPPED = 2;
    private static final byte TRANSITION = 16;
    private static final byte STARTING = 17;
    private static final byte STOPPING = 18;
    private final Executor _executor;

    protected AbstractSingleThreadRunner(String name) {
        this._executor = new Executor(name);
    }

    public final String getName() {
        return this._executor.name;
    }

    public final boolean start() {
        return this._executor.start();
    }

    public final boolean stop() {
        return this._executor.stop();
    }

    public final boolean isInState(byte requiredState) {
        return this._executor.isInState(requiredState);
    }

    public final boolean waitForState(int timeout, byte requiredState) throws InterruptedException {
        return this._executor.waitForState(timeout, requiredState);
    }

    protected abstract void doRun();

    protected void forkExecution(Runnable runnable, String name) {
        new Thread(runnable, name).start();
    }

    protected void unblock() {
        this._executor.interrupt();
    }

    protected final boolean isCancelled() {
        return this._executor.isInState((byte)18);
    }

    private final class Executor
    implements Runnable {
        protected final String name;
        private Thread _workThread;
        private final Object _mutex = new Object();
        private int _state;

        Executor(String name) {
            this.name = name == null ? AbstractSingleThreadRunner.this.getClass().getName() : name;
            this._state = 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this._mutex;
            synchronized (object) {
                this._workThread = Thread.currentThread();
                this._state = 1;
                this._mutex.notifyAll();
            }
            try {
                AbstractSingleThreadRunner.this.doRun();
            }
            finally {
                object = this._mutex;
                synchronized (object) {
                    this._state = 2;
                    this._workThread = null;
                    this._mutex.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean start() {
            Object object = this._mutex;
            synchronized (object) {
                if (this._state == 2) {
                    this._state = 17;
                    AbstractSingleThreadRunner.this.forkExecution(this, this.name);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean stop() {
            Object object = this._mutex;
            synchronized (object) {
                if (this._state == 1) {
                    this._state = 18;
                    AbstractSingleThreadRunner.this.unblock();
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interrupt() {
            Object object = this._mutex;
            synchronized (object) {
                if (this._workThread != null) {
                    this._workThread.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isInState(byte requiredState) {
            Object object = this._mutex;
            synchronized (object) {
                return this._state == requiredState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitForState(long timeout, byte requiredState) throws InterruptedException {
            long start = System.currentTimeMillis();
            Object object = this._mutex;
            synchronized (object) {
                while (this._state != requiredState) {
                    if ((this._state & 0x10) <= 0 || Thread.currentThread() == this._workThread) {
                        return false;
                    }
                    long toWait = timeout - (System.currentTimeMillis() - start);
                    if (toWait > 0L) {
                        this._mutex.wait(toWait);
                        continue;
                    }
                    throw new InterruptedException("timed out");
                }
            }
            return true;
        }
    }
}

