/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.util;

import com.github.libxjava.util.BasicEnumeration;
import java.util.NoSuchElementException;

public class BasicHashMap {
    private static final int LOAD_FACTOR_PERCENT = 75;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAX_CAPACITY = 0x40000000;
    private Entry[] _table;
    private int _count;
    private int _threshold;

    private static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public BasicHashMap() {
        this(16);
    }

    public BasicHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        for (int capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this._table = new Entry[initialCapacity];
        this._threshold = initialCapacity * 75 / 100;
    }

    public void clear() {
        Entry[] tab = this._table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this._count = 0;
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            Entry[] tab = this._table;
            for (int i = 0; i < tab.length; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
        } else {
            Entry[] tab = this._table;
            for (int i = 0; i < tab.length; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    public BasicEnumeration elements() {
        return new Enumerator(this._table, false);
    }

    public Object get(Object key) {
        Entry e = this.getEntry(key);
        return e != null ? e.value : null;
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public BasicEnumeration keys() {
        return new Enumerator(this._table, true);
    }

    public Object put(Object key, Object value) {
        int hash = key == null ? 0 : BasicHashMap.hash(key.hashCode());
        int i = BasicHashMap.indexFor(hash, this._table.length);
        Entry e = this._table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.addEntry(hash, key, value, i);
        return null;
    }

    public Object remove(Object key) {
        Entry prev;
        int hash = key == null ? 0 : BasicHashMap.hash(key.hashCode());
        int i = BasicHashMap.indexFor(hash, this._table.length);
        Entry e = prev = this._table[i];
        while (e != null) {
            Object k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                --this._count;
                if (prev == e) {
                    this._table[i] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    public int size() {
        return this._count;
    }

    public String toString() {
        if (this._count == 0) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        int max = this._count - 1;
        Entry entry = null;
        int e = 0;
        for (int i = 0; i <= max; ++i) {
            while (entry == null) {
                entry = this._table[e++];
            }
            Object key = entry.key;
            Object value = entry.value;
            buffer.append(key == this ? "(this Map)" : key);
            buffer.append('=');
            buffer.append(value == this ? "(this Map)" : value);
            entry = entry.next;
            if (i >= max) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        return buffer.toString();
    }

    private void addEntry(int hash, Object key, Object value, int bucketIndex) {
        Entry e = this._table[bucketIndex];
        this._table[bucketIndex] = new Entry(hash, key, value, e);
        if (this._count++ >= this._threshold) {
            this.resize(this._table.length << 1);
        }
    }

    private Entry getEntry(Object key) {
        int hash = key == null ? 0 : BasicHashMap.hash(key.hashCode());
        Entry e = this._table[BasicHashMap.indexFor(hash, this._table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private void resize(int newCapacity) {
        Entry[] oldTable = this._table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this._threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this._table = newTable;
        this._threshold = newCapacity * 75 / 100;
        for (int j = 0; j < oldTable.length; ++j) {
            Entry next;
            Entry e = oldTable[j];
            if (e == null) continue;
            oldTable[j] = null;
            do {
                next = e.next;
                int i = BasicHashMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    private final class Enumerator
    implements BasicEnumeration {
        boolean keys;
        int index;
        Entry[] table;
        Entry entry;
        Entry lastAccessedElement;

        Enumerator(Entry[] table, boolean keys) {
            this.table = table;
            this.keys = keys;
            this.index = table.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                Entry e = this.entry;
                this.entry = e.next;
                this.lastAccessedElement = e;
                return this.keys ? e.key : e.value;
            }
            this.lastAccessedElement = null;
            throw new NoSuchElementException("HashMapEnumeration");
        }

        public void remove() {
            if (this.lastAccessedElement == null) {
                throw new RuntimeException("illegal state");
            }
            Object k = this.lastAccessedElement.key;
            this.entry = null;
            BasicHashMap.this.remove(k);
            this.lastAccessedElement = null;
        }
    }

    private static final class Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

