/*
 * libxjava -- utility library for cross-Java-platform development
 *             Lib-Cross-Java JSE5
 *
 * Copyright (c) 2010 Marcel Patzlaff (marcel.patzlaff@gmail.com)
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.github.libxjava.util;

import java.util.HashMap;

/**
 * @author Marcel Patzlaff
 * @version libxjava-jse5 - 0.2
 */
public class BasicHashMap<K,V> extends HashMap<K,V> {
    private static final long serialVersionUID= 1L;

    public BasicHashMap() {
        super();
    }
    
    public BasicHashMap(int initialCapacity) {
        super(initialCapacity);
    }
    
    public void clear() {
        super.clear();
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public BasicEnumeration<V> elements() {
        return new IteratorWrapper(super.values().iterator());
    }

    public V/*Object/**/ get(Object key) {
        return super.get(key);
    }

    public boolean isEmpty() {
        return super.isEmpty();
    }

    public BasicEnumeration<K> keys() {
        return new IteratorWrapper(super.keySet().iterator());
    }

    public V/*Object/**/ put(K/*Object/**/ key, V/*Object/**/ value) {
        return super.put(key, value);
    }

    public V/*Object/**/ remove(Object key) {
        return super.remove(key);
    }

    public int size() {
        return super.size();
    }
    
    public String toString() {
        return super.toString();
    }
}
