/*
 * libxjava -- utility library for cross-Java-platform development
 *             Lib-Cross-Java JSE5
 *
 * Copyright (c) 2010 Marcel Patzlaff (marcel.patzlaff@gmail.com)
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.github.libxjava.concurrent;

import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.TimeUnit;

/**
 *
 * @author Marcel Patzlaff
 * @version libxjava-jse5 - 0.3
 */
public class TaskFuture {
    /*package*/ RunnableScheduledFuture<?> future;
    
    protected TaskFuture() {}
    
    public final boolean isCancelled() {
        return future.isCancelled();
    }

    public final boolean isPeriodic() {
        return future.isPeriodic();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        return future.cancel(mayInterruptIfRunning);
    }

    public final boolean isDone() {
        return future.isDone();
    }

    public final long getDelayInMillis() {
        return future.getDelay(TimeUnit.MILLISECONDS);
    }
}
