/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import com.github.libxjava.io.BinaryDeserialiserStream;
import com.github.libxjava.io.BinarySerialiserStream;
import com.github.libxjava.lang.IClassLoader;
import com.github.libxjava.util.IntHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class ReferenceCache {
    private final IntHashMap _numToReference = new IntHashMap();
    private final HashMap _referenceToNum = new HashMap();

    public final BinaryDeserialiserStream createDeserialiser(IClassLoader classLoader, InputStream in) {
        return new CachedReferenceBinaryDeserialiserStream(classLoader, in);
    }

    public final BinarySerialiserStream createSerialiser(OutputStream out) {
        return new CachedReferenceBinarySerialiserStream(out);
    }

    public final void cacheReference(Object obj) {
        int refNum = this.getReferenceCount();
        this._numToReference.put(refNum, obj);
        this._referenceToNum.put(obj, (byte)refNum);
    }

    public final int getReferenceCount() {
        return this._numToReference.size();
    }

    protected final Byte getReferenceNumber(Object obj) {
        return (Byte)this._referenceToNum.get(obj);
    }

    protected final Object getReference(byte refNum) {
        return this._numToReference.get(refNum);
    }

    private final class CachedReferenceBinaryDeserialiserStream
    extends BinaryDeserialiserStream {
        public CachedReferenceBinaryDeserialiserStream(IClassLoader classLoader, InputStream in) {
            super(classLoader, in);
            this.referenceCounter = ReferenceCache.this.getReferenceCount();
        }

        public void flush() {
            super.flush();
            this.referenceCounter = ReferenceCache.this.getReferenceCount();
        }

        protected Object getReference(byte num) {
            Object ref = ReferenceCache.this.getReference(num);
            if (ref != null) {
                return ref;
            }
            return super.getReference(num);
        }
    }

    private final class CachedReferenceBinarySerialiserStream
    extends BinarySerialiserStream {
        protected CachedReferenceBinarySerialiserStream(OutputStream out) {
            super(out);
            this.referenceCounter = ReferenceCache.this.getReferenceCount();
        }

        public void flush() throws IOException {
            super.flush();
            this.referenceCounter = ReferenceCache.this.getReferenceCount();
        }

        protected Byte getReferenceNumber(Object obj) {
            Byte refNum = ReferenceCache.this.getReferenceNumber(obj);
            return refNum != null ? refNum : super.getReferenceNumber(obj);
        }
    }
}

