/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.util;

import com.github.libxjava.io.IDeserialiser;
import com.github.libxjava.io.ISerialisable;
import com.github.libxjava.io.ISerialiser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialisableHashtable<K, V>
extends Hashtable<K, V>
implements ISerialisable {
    private static final long serialVersionUID = 1L;

    public SerialisableHashtable() {
    }

    public SerialisableHashtable(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public synchronized void deserialise(IDeserialiser in) throws IOException, ClassNotFoundException {
        this.clear();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            super.put(in.readObject(), in.readObject());
        }
    }

    @Override
    public synchronized void serialise(ISerialiser out) throws IOException {
        int count = this.size();
        out.writeInt(count);
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            out.writeObject(key);
            out.writeObject(this.get(key));
        }
    }
}

