/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util.datastructure;

import de.mrapp.util.Condition;
import de.mrapp.util.datastructure.SortedArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortedArraySet<T>
implements SortedSet<T> {
    private final SortedArrayList<T> sortedArrayList;
    private final Set<Integer> hashCodes;

    public SortedArraySet() {
        this((Comparator)null);
    }

    public SortedArraySet(Collection<T> items) {
        this((Comparator)null);
        this.addAll(items);
    }

    public SortedArraySet(int initialCapacity) {
        this(initialCapacity, null);
    }

    public SortedArraySet(@Nullable Comparator<? super T> comparator) {
        this.sortedArrayList = new SortedArrayList<T>(comparator);
        this.hashCodes = new HashSet<Integer>();
    }

    public SortedArraySet(@NotNull Collection<T> items, @Nullable Comparator<? super T> comparator) {
        this(comparator);
        this.addAll(items);
    }

    public SortedArraySet(int initialCapacity, @Nullable Comparator<? super T> comparator) {
        this.sortedArrayList = new SortedArrayList<T>(initialCapacity, comparator);
        this.hashCodes = new HashSet<Integer>(initialCapacity);
    }

    @Override
    @Nullable
    public Comparator<? super T> comparator() {
        return this.sortedArrayList.comparator();
    }

    @Override
    @NotNull
    public SortedSet<T> subSet(@NotNull T fromElement, @NotNull T toElement) {
        Condition.ensureNotNull(fromElement, "The fromElement may not be null");
        Condition.ensureNotNull(toElement, "The toElement may not be null");
        int start = this.sortedArrayList.indexOf(fromElement);
        Condition.ensureNotEqual(start, -1, "fromElement not contained by set", NoSuchElementException.class);
        int end = this.sortedArrayList.indexOf(toElement);
        Condition.ensureNotEqual(end, -1, "toElement not contained by set", NoSuchElementException.class);
        Condition.ensureFalse(start > end, "fromElement greater than toElement");
        SortedArraySet<T> subSet = new SortedArraySet<T>(end - start + 1);
        for (int i = start; i <= end; ++i) {
            subSet.add(this.sortedArrayList.get(i));
        }
        return subSet;
    }

    @Override
    @NotNull
    public SortedSet<T> headSet(@NotNull T toElement) {
        Condition.ensureNotNull(toElement, "The toElement may not be null");
        int end = this.sortedArrayList.indexOf(toElement);
        Condition.ensureNotEqual(end, -1, "toElement not contained by set", NoSuchElementException.class);
        SortedArraySet<T> headSet = new SortedArraySet<T>(end + 1);
        for (int i = 0; i <= end; ++i) {
            headSet.add(this.sortedArrayList.get(i));
        }
        return headSet;
    }

    @Override
    @NotNull
    public SortedSet<T> tailSet(@NotNull T fromElement) {
        Condition.ensureNotNull(fromElement, "The fromElement may not be null");
        int start = this.sortedArrayList.indexOf(fromElement);
        Condition.ensureNotEqual(start, -1, "fromElement not contained by set", NoSuchElementException.class);
        SortedArraySet<T> tailSet = new SortedArraySet<T>(this.size() - start);
        for (int i = start; i < this.size(); ++i) {
            tailSet.add(this.sortedArrayList.get(i));
        }
        return tailSet;
    }

    @Override
    @NotNull
    public T first() {
        Condition.ensureFalse(this.isEmpty(), "Set is empty", NoSuchElementException.class);
        return (T)this.sortedArrayList.get(0);
    }

    @Override
    @NotNull
    public T last() {
        Condition.ensureFalse(this.isEmpty(), "Set is empty", NoSuchElementException.class);
        return (T)this.sortedArrayList.get(this.sortedArrayList.size() - 1);
    }

    @Override
    public int size() {
        return this.sortedArrayList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sortedArrayList.isEmpty();
    }

    @Override
    public boolean contains(@NotNull Object item) {
        Condition.ensureNotNull(item, "The item may not be null");
        return this.hashCodes.contains(item.hashCode());
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.sortedArrayList.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.sortedArrayList.toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] array) {
        Condition.ensureNotNull(array, "The array may not be null");
        return this.sortedArrayList.toArray(array);
    }

    @Override
    public boolean add(@NotNull T item) {
        Condition.ensureNotNull(item, "The item may not be null");
        int hashCode = item.hashCode();
        if (!this.hashCodes.contains(hashCode)) {
            this.sortedArrayList.add(item);
            this.hashCodes.add(hashCode);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(@NotNull Object item) {
        Condition.ensureNotNull(item, "The item may not be null");
        int hashCode = item.hashCode();
        if (this.hashCodes.remove(hashCode)) {
            this.sortedArrayList.remove(item);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> items) {
        Condition.ensureNotNull(items, "The collection may not be null");
        return items.stream().map(this::contains).reduce(true, (a, b) -> a != false && b != false);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> items) {
        Condition.ensureNotNull(items, "The collection may not be null");
        if (!items.isEmpty()) {
            return items.stream().map(this::add).reduce(true, (a, b) -> a != false && b != false);
        }
        return false;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> items) {
        Condition.ensureNotNull(items, "The collection may not be null");
        if (!items.isEmpty()) {
            boolean result = false;
            for (int i = this.size() - 1; i >= 0; --i) {
                Object item = this.sortedArrayList.get(i);
                if (items.contains(item)) continue;
                int hashCode = item.hashCode();
                this.sortedArrayList.remove(i);
                this.hashCodes.remove(hashCode);
                result = true;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> items) {
        Condition.ensureNotNull(items, "The collection may not be null");
        if (!items.isEmpty()) {
            return items.stream().map(this::remove).reduce(true, (a, b) -> a != false && b != false);
        }
        return false;
    }

    @Override
    public void clear() {
        this.hashCodes.clear();
        this.sortedArrayList.clear();
    }

    public String toString() {
        return this.sortedArrayList.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hashCodes.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortedArraySet other = (SortedArraySet)obj;
        return this.hashCodes.equals(other.hashCodes);
    }
}

