/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util;

import de.mrapp.util.Condition;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004J.\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\tJ6\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\rJ6\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\t\"\u0004\b\u0000\u0010\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000e0\rJ:\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0004\"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00120\rJ:\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\t\"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010\u00122\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00130\t2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00120\rJB\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u0004\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00042\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u0002H\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\t0\rJB\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\t\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00180\t2\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u0002H\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\t0\rJ\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\u0004J\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\"\u0004\b\u0000\u0010\u00052\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\t\u00a8\u0006\u001f"}, d2={"Lde/mrapp/util/IteratorUtil;", "", "()V", "createConcatenatedIterable", "", "T", "first", "second", "createConcatenatedIterator", "", "createFilteredIterable", "iterable", "filter", "Lkotlin/Function1;", "", "createFilteredIterator", "iterator", "createMappedIterable", "O", "I", "mapper", "createMappedIterator", "createNestedIterable", "T2", "T1", "outerIterable", "factory", "createNestedIterator", "outerIterator", "createNotNullIterable", "createNotNullIterator", "JavaUtil"})
public final class IteratorUtil {
    public static final IteratorUtil INSTANCE;

    @NotNull
    public final <I, O> Iterable<O> createMappedIterable(@NotNull Iterable<? extends I> iterable, @NotNull Function1<? super I, ? extends O> mapper) {
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
        Intrinsics.checkParameterIsNotNull(mapper, (String)"mapper");
        Condition.INSTANCE.ensureNotNull(iterable, "The iterable may not be null");
        Condition.INSTANCE.ensureNotNull(mapper, "The mapper may not be null");
        boolean bl = false;
        return new Iterable<O>(iterable, mapper){
            final /* synthetic */ Iterable $iterable$inlined;
            final /* synthetic */ Function1 $mapper$inlined;
            {
                this.$iterable$inlined = iterable;
                this.$mapper$inlined = function1;
            }

            @NotNull
            public Iterator<O> iterator() {
                boolean bl = false;
                return IteratorUtil.INSTANCE.createMappedIterator(this.$iterable$inlined.iterator(), this.$mapper$inlined);
            }
        };
    }

    @NotNull
    public final <I, O> Iterator<O> createMappedIterator(@NotNull Iterator<? extends I> iterator, @NotNull Function1<? super I, ? extends O> mapper) {
        Intrinsics.checkParameterIsNotNull(iterator, (String)"iterator");
        Intrinsics.checkParameterIsNotNull(mapper, (String)"mapper");
        Condition.INSTANCE.ensureNotNull(iterator, "The iterator may not be null");
        Condition.INSTANCE.ensureNotNull(mapper, "The mapper may not be null");
        return new Iterator<O>(iterator, mapper){
            final /* synthetic */ Iterator $iterator;
            final /* synthetic */ Function1 $mapper;

            public boolean hasNext() {
                return this.$iterator.hasNext();
            }

            public O next() {
                return (O)this.$mapper.invoke(this.$iterator.next());
            }
            {
                this.$iterator = $captured_local_variable$0;
                this.$mapper = $captured_local_variable$1;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final <T> Iterable<T> createConcatenatedIterable(@NotNull Iterable<? extends T> first, @NotNull Iterable<? extends T> second) {
        Intrinsics.checkParameterIsNotNull(first, (String)"first");
        Intrinsics.checkParameterIsNotNull(second, (String)"second");
        Condition.INSTANCE.ensureNotNull(first, "The first iterable may not be null");
        Condition.INSTANCE.ensureNotNull(second, "The second iterable may not be null");
        boolean bl = false;
        return new Iterable<T>(first, second){
            final /* synthetic */ Iterable $first$inlined;
            final /* synthetic */ Iterable $second$inlined;
            {
                this.$first$inlined = iterable;
                this.$second$inlined = iterable2;
            }

            @NotNull
            public Iterator<T> iterator() {
                boolean bl = false;
                return IteratorUtil.INSTANCE.createConcatenatedIterator(this.$first$inlined.iterator(), this.$second$inlined.iterator());
            }
        };
    }

    @NotNull
    public final <T> Iterator<T> createConcatenatedIterator(@NotNull Iterator<? extends T> first, @NotNull Iterator<? extends T> second) {
        Intrinsics.checkParameterIsNotNull(first, (String)"first");
        Intrinsics.checkParameterIsNotNull(second, (String)"second");
        Condition.INSTANCE.ensureNotNull(first, "The first iterator may not be null");
        Condition.INSTANCE.ensureNotNull(second, "The second iterator may not be null");
        return new Iterator<T>(first, second){
            final /* synthetic */ Iterator $first;
            final /* synthetic */ Iterator $second;

            public boolean hasNext() {
                return this.$first.hasNext() || this.$second.hasNext();
            }

            public T next() {
                E e;
                try {
                    e = this.$first.next();
                }
                catch (NoSuchElementException e2) {
                    e = this.$second.next();
                }
                return (T)e;
            }
            {
                this.$first = $captured_local_variable$0;
                this.$second = $captured_local_variable$1;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final <T> Iterable<T> createFilteredIterable(@NotNull Iterable<? extends T> iterable, @NotNull Function1<? super T, Boolean> filter) {
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Condition.INSTANCE.ensureNotNull(iterable, "The iterable may not be null");
        Condition.INSTANCE.ensureNotNull(filter, "The filter may not be null");
        boolean bl = false;
        return new Iterable<T>(iterable, filter){
            final /* synthetic */ Iterable $iterable$inlined;
            final /* synthetic */ Function1 $filter$inlined;
            {
                this.$iterable$inlined = iterable;
                this.$filter$inlined = function1;
            }

            @NotNull
            public Iterator<T> iterator() {
                boolean bl = false;
                return IteratorUtil.INSTANCE.createFilteredIterator(this.$iterable$inlined.iterator(), this.$filter$inlined);
            }
        };
    }

    @NotNull
    public final <T> Iterator<T> createFilteredIterator(@NotNull Iterator<? extends T> iterator, @NotNull Function1<? super T, Boolean> filter) {
        Intrinsics.checkParameterIsNotNull(iterator, (String)"iterator");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Condition.INSTANCE.ensureNotNull(iterator, "The iterator may not be null");
        Condition.INSTANCE.ensureNotNull(filter, "The filter may not be null");
        return new Iterator<T>(iterator, filter){
            private boolean hasNext;
            private T next;
            final /* synthetic */ Iterator $iterator;
            final /* synthetic */ Function1 $filter;

            private final void computeNext() {
                this.hasNext = false;
                while (this.$iterator.hasNext()) {
                    E next = this.$iterator.next();
                    if (!((Boolean)this.$filter.invoke(next)).booleanValue()) continue;
                    this.hasNext = true;
                    this.next = next;
                    return;
                }
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public T next() {
                void var1_1;
                if (!this.hasNext) {
                    throw (Throwable)new NoSuchElementException();
                }
                T result = this.next;
                this.computeNext();
                return var1_1;
            }
            {
                this.$iterator = $captured_local_variable$0;
                this.$filter = $captured_local_variable$1;
                this.computeNext();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final <T> Iterable<T> createNotNullIterable(@NotNull Iterable<? extends T> iterable) {
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
        Condition.INSTANCE.ensureNotNull(iterable, "The iterable may not be null");
        boolean bl = false;
        return new Iterable<T>(iterable){
            final /* synthetic */ Iterable $iterable$inlined;
            {
                this.$iterable$inlined = iterable;
            }

            @NotNull
            public Iterator<T> iterator() {
                boolean bl = false;
                return IteratorUtil.INSTANCE.createNotNullIterator(this.$iterable$inlined.iterator());
            }
        };
    }

    @NotNull
    public final <T> Iterator<T> createNotNullIterator(@NotNull Iterator<? extends T> iterator) {
        Intrinsics.checkParameterIsNotNull(iterator, (String)"iterator");
        Condition.INSTANCE.ensureNotNull(iterator, "The iterator may not be null");
        return new Iterator<T>(iterator){
            private T next;
            final /* synthetic */ Iterator $iterator;

            private final T computeNext() {
                T result = null;
                while (result == null && this.$iterator.hasNext()) {
                    E next = this.$iterator.next();
                    if (next == null) continue;
                    result = (T)next;
                }
                return result;
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public T next() {
                T t;
                block3: {
                    block2: {
                        t = this.next;
                        if (t == null) break block2;
                        T t2 = t;
                        boolean bl = false;
                        boolean bl2 = false;
                        T it = t2;
                        boolean bl3 = false;
                        this.next = this.computeNext();
                        t = it;
                        if (t != null) break block3;
                    }
                    throw (Throwable)new NoSuchElementException();
                }
                return t;
            }
            {
                this.$iterator = $captured_local_variable$0;
                this.next = this.computeNext();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final <T1, T2> Iterable<T2> createNestedIterable(@NotNull Iterable<? extends T1> outerIterable, @NotNull Function1<? super T1, ? extends Iterator<? extends T2>> factory) {
        Intrinsics.checkParameterIsNotNull(outerIterable, (String)"outerIterable");
        Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
        Condition.INSTANCE.ensureNotNull(outerIterable, "The iterable may not be null");
        Condition.INSTANCE.ensureNotNull(factory, "The factory may not be null");
        boolean bl = false;
        return new Iterable<T2>(outerIterable, factory){
            final /* synthetic */ Iterable $outerIterable$inlined;
            final /* synthetic */ Function1 $factory$inlined;
            {
                this.$outerIterable$inlined = iterable;
                this.$factory$inlined = function1;
            }

            @NotNull
            public Iterator<T2> iterator() {
                boolean bl = false;
                return IteratorUtil.INSTANCE.createNestedIterator(this.$outerIterable$inlined.iterator(), this.$factory$inlined);
            }
        };
    }

    @NotNull
    public final <T1, T2> Iterator<T2> createNestedIterator(@NotNull Iterator<? extends T1> outerIterator, @NotNull Function1<? super T1, ? extends Iterator<? extends T2>> factory) {
        Intrinsics.checkParameterIsNotNull(outerIterator, (String)"outerIterator");
        Intrinsics.checkParameterIsNotNull(factory, (String)"factory");
        Condition.INSTANCE.ensureNotNull(outerIterator, "The iterator may not be null");
        Condition.INSTANCE.ensureNotNull(factory, "The factory may not be null");
        return new Iterator<T2>(outerIterator, factory){
            private Iterator<? extends T2> innerIterator;
            private boolean hasNext;
            private T2 next;
            final /* synthetic */ Iterator $outerIterator;
            final /* synthetic */ Function1 $factory;

            private final void computeNext() {
                this.hasNext = false;
                Iterator iterator = this.innerIterator;
                while (iterator != null && iterator.hasNext() || this.$outerIterator.hasNext()) {
                    if (iterator != null && iterator.hasNext()) {
                        this.hasNext = true;
                        this.next = iterator.next();
                        return;
                    }
                    Object object = this.$factory.invoke(this.$outerIterator.next());
                    boolean bl = false;
                    boolean bl2 = false;
                    Iterator it = (Iterator)object;
                    boolean bl3 = false;
                    this.innerIterator = it;
                    iterator = (Iterator)object;
                }
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public T2 next() {
                void var1_1;
                if (!this.hasNext) {
                    throw (Throwable)new NoSuchElementException();
                }
                T2 result = this.next;
                this.computeNext();
                return var1_1;
            }
            {
                this.$outerIterator = $captured_local_variable$0;
                this.$factory = $captured_local_variable$1;
                this.computeNext();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    private IteratorUtil() {
    }

    static {
        IteratorUtil iteratorUtil;
        INSTANCE = iteratorUtil = new IteratorUtil();
    }
}

