/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.cronparser.domain;

import lombok.Generated;
import uk.co.mruoc.cronparser.domain.CronResult;
import uk.co.mruoc.cronparser.domain.NotationParserNotFoundException;
import uk.co.mruoc.cronparser.domain.TimeUnit;
import uk.co.mruoc.cronparser.domain.notation.ComplexNotationParser;
import uk.co.mruoc.cronparser.domain.notation.NotationParser;

public class CronExpressionParser {
    private final NotationParser notationParser;

    public CronExpressionParser() {
        this(new ComplexNotationParser());
    }

    public CronResult parse(String[] values) {
        return CronResult.builder().minutes(this.parse(values, TimeUnit.MINUTES)).hours(this.parse(values, TimeUnit.HOURS)).daysOfMonth(this.parse(values, TimeUnit.DAYS_OF_MONTH)).months(this.parse(values, TimeUnit.MONTHS)).daysOfWeek(this.parse(values, TimeUnit.DAYS_OF_WEEK)).command(values[5]).build();
    }

    private int[] parse(String[] values, TimeUnit timeUnit) {
        String rawValues = values[timeUnit.ordinal()];
        String intValues = timeUnit.toIntValues(rawValues);
        if (this.notationParser.appliesTo(intValues)) {
            return this.notationParser.toValues(intValues, timeUnit);
        }
        throw new NotationParserNotFoundException(rawValues);
    }

    @Generated
    public CronExpressionParser(NotationParser notationParser) {
        this.notationParser = notationParser;
    }
}

