/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.cronparser.domain.notation;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import uk.co.mruoc.cronparser.domain.TimeUnit;
import uk.co.mruoc.cronparser.domain.notation.IntervalNotationParser;
import uk.co.mruoc.cronparser.domain.notation.NotationParser;
import uk.co.mruoc.cronparser.domain.notation.RangeNotationParser;
import uk.co.mruoc.cronparser.domain.notation.SimpleNotationParser;
import uk.co.mruoc.cronparser.domain.notation.WildcardNotationParser;

public class ComplexNotationParser
implements NotationParser {
    private final Collection<NotationParser> parsers;

    public ComplexNotationParser() {
        this(new WildcardNotationParser(), new RangeNotationParser(), new IntervalNotationParser(), new SimpleNotationParser());
    }

    public ComplexNotationParser(NotationParser ... parsers) {
        this(Arrays.asList(parsers));
    }

    @Override
    public boolean appliesTo(String value) {
        if (this.appliesToSegment(value)) {
            return true;
        }
        return this.toSegments(value).stream().allMatch(this::appliesToSegment);
    }

    @Override
    public int[] toValues(String input, TimeUnit unit) {
        if (this.appliesToSegment(input)) {
            return this.segmentToValues(input, unit).toArray();
        }
        return this.toSegments(input).stream().flatMapToInt(segment -> this.segmentToValues((String)segment, unit)).sorted().toArray();
    }

    private Collection<String> toSegments(String value) {
        return Arrays.asList(StringUtils.split(value, ","));
    }

    private boolean appliesToSegment(String segment) {
        return this.parsers.stream().anyMatch(parser -> parser.appliesTo(segment));
    }

    private IntStream segmentToValues(String segment, TimeUnit unit) {
        return this.parsers.stream().filter(parser -> parser.appliesTo(segment)).map(parser -> parser.toValues(segment, unit)).map(IntStream::of).flatMapToInt(Function.identity());
    }

    @Generated
    public ComplexNotationParser(Collection<NotationParser> parsers) {
        this.parsers = parsers;
    }
}

