/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.cronparser.domain.notation;

import java.util.Arrays;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import uk.co.mruoc.cronparser.domain.TimeUnit;
import uk.co.mruoc.cronparser.domain.notation.InvalidNotationException;
import uk.co.mruoc.cronparser.domain.notation.NotationParser;
import uk.co.mruoc.cronparser.domain.notation.RangeNotationParser;
import uk.co.mruoc.cronparser.domain.notation.SimpleNotationParser;
import uk.co.mruoc.cronparser.domain.notation.StringUtil;

public class IntervalNotationParser
implements NotationParser {
    private static final String WILDCARD = "*";
    private final SimpleNotationParser simpleParser;
    private final RangeNotationParser rangeParser;

    public IntervalNotationParser() {
        this(new SimpleNotationParser(), new RangeNotationParser());
    }

    @Override
    public boolean appliesTo(String value) {
        String[] parts = IntervalNotationParser.split(value);
        if (parts.length == 2) {
            return this.isIntWildcardRangeOrIntegers(parts[0]) && StringUtil.isInt(parts[1]);
        }
        return false;
    }

    @Override
    public int[] toValues(String input, TimeUnit unit) {
        try {
            String[] parts = IntervalNotationParser.split(input);
            int[] starts = this.toStarts(parts[0], unit);
            unit.validate(starts);
            int interval = Integer.parseInt(parts[1]);
            return IntervalNotationParser.calculateIntervals(starts, unit, interval);
        }
        catch (ArrayIndexOutOfBoundsException | InvalidNotationException e) {
            throw new InvalidNotationException(input, e);
        }
    }

    private static String[] split(String value) {
        return StringUtils.split(value, "/");
    }

    private int[] toStarts(String value, TimeUnit unit) {
        if (WILDCARD.equals(value)) {
            return new int[]{unit.getLowerBound()};
        }
        if (this.rangeParser.appliesTo(value)) {
            return this.rangeParser.toValues(value, unit);
        }
        return this.simpleParser.toValues(value, unit);
    }

    private static int[] calculateIntervals(int[] starts, TimeUnit unit, int interval) {
        return Arrays.stream(starts).flatMap(start -> IntervalNotationParser.calculateIntervals(start, unit, interval)).distinct().sorted().toArray();
    }

    private static IntStream calculateIntervals(int start, TimeUnit unit, int interval) {
        return IntStream.iterate(start, IntervalNotationParser.lessThanOrEqualToUpperBound(unit), IntervalNotationParser.incrementBy(interval));
    }

    private static IntPredicate lessThanOrEqualToUpperBound(TimeUnit unit) {
        return i -> i <= unit.getUpperBound();
    }

    private static IntUnaryOperator incrementBy(int interval) {
        return i -> i + interval;
    }

    private boolean isIntWildcardRangeOrIntegers(String value) {
        return WILDCARD.equals(value) || this.rangeParser.appliesTo(value) || this.simpleParser.appliesTo(value);
    }

    @Generated
    public IntervalNotationParser(SimpleNotationParser simpleParser, RangeNotationParser rangeParser) {
        this.simpleParser = simpleParser;
        this.rangeParser = rangeParser;
    }
}

