/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_AC_OUTPUT;

public class AC_GetCapabilityResponse
extends TpmStructure {
    public byte moreData;
    public TPMS_AC_OUTPUT[] capabilitiesData;

    public AC_GetCapabilityResponse(byte _moreData, TPMS_AC_OUTPUT[] _capabilitiesData) {
        this.moreData = _moreData;
        this.capabilitiesData = _capabilitiesData;
    }

    public AC_GetCapabilityResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.moreData);
        buf.writeInt(this.capabilitiesData != null ? this.capabilitiesData.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.capabilitiesData);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.moreData = (byte)buf.readInt(1);
        int _capabilitiesDataCount = buf.readInt(4);
        this.capabilitiesData = new TPMS_AC_OUTPUT[_capabilitiesDataCount];
        for (int j = 0; j < _capabilitiesDataCount; ++j) {
            this.capabilitiesData[j] = new TPMS_AC_OUTPUT();
        }
        buf.readArrayOfTpmObjects(this.capabilitiesData, _capabilitiesDataCount);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static AC_GetCapabilityResponse fromTpm(byte[] x) {
        AC_GetCapabilityResponse ret = new AC_GetCapabilityResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static AC_GetCapabilityResponse fromTpm(InByteBuf buf) {
        AC_GetCapabilityResponse ret = new AC_GetCapabilityResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_AC_GetCapability_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "BYTE", "moreData", this.moreData);
        _p.add(d, "TPMS_AC_OUTPUT", "capabilitiesData", this.capabilitiesData);
    }
}

