/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ECC_POINT;
import tss.tpm.TPM_HANDLE;

public class TPM2_Commit_REQUEST
extends TpmStructure {
    public TPM_HANDLE signHandle;
    public TPMS_ECC_POINT P1;
    public byte[] s2;
    public byte[] y2;

    public TPM2_Commit_REQUEST(TPM_HANDLE _signHandle, TPMS_ECC_POINT _P1, byte[] _s2, byte[] _y2) {
        this.signHandle = _signHandle;
        this.P1 = _P1;
        this.s2 = _s2;
        this.y2 = _y2;
    }

    public TPM2_Commit_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.signHandle.toTpm(buf);
        buf.writeInt(this.P1 != null ? this.P1.toTpm().length : 0, 2);
        this.P1.toTpm(buf);
        buf.writeInt(this.s2 != null ? this.s2.length : 0, 2);
        buf.write(this.s2);
        buf.writeInt(this.y2 != null ? this.y2.length : 0, 2);
        buf.write(this.y2);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.signHandle = TPM_HANDLE.fromTpm(buf);
        int _P1Size = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _P1Size));
        this.P1 = TPMS_ECC_POINT.fromTpm(buf);
        buf.structSize.pop();
        int _s2Size = buf.readInt(2);
        this.s2 = new byte[_s2Size];
        buf.readArrayOfInts(this.s2, 1, _s2Size);
        int _y2Size = buf.readInt(2);
        this.y2 = new byte[_y2Size];
        buf.readArrayOfInts(this.y2, 1, _y2Size);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_Commit_REQUEST fromTpm(byte[] x) {
        TPM2_Commit_REQUEST ret = new TPM2_Commit_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_Commit_REQUEST fromTpm(InByteBuf buf) {
        TPM2_Commit_REQUEST ret = new TPM2_Commit_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Commit_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "signHandle", this.signHandle);
        _p.add(d, "TPMS_ECC_POINT", "P1", this.P1);
        _p.add(d, "byte", "s2", this.s2);
        _p.add(d, "byte", "y2", this.y2);
    }
}

