/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPM_HANDLE;

public class TPM2_Load_REQUEST
extends TpmStructure {
    public TPM_HANDLE parentHandle;
    public TPM2B_PRIVATE inPrivate;
    public TPMT_PUBLIC inPublic;

    public TPM2_Load_REQUEST(TPM_HANDLE _parentHandle, TPM2B_PRIVATE _inPrivate, TPMT_PUBLIC _inPublic) {
        this.parentHandle = _parentHandle;
        this.inPrivate = _inPrivate;
        this.inPublic = _inPublic;
    }

    public TPM2_Load_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.parentHandle.toTpm(buf);
        this.inPrivate.toTpm(buf);
        buf.writeInt(this.inPublic != null ? this.inPublic.toTpm().length : 0, 2);
        this.inPublic.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.parentHandle = TPM_HANDLE.fromTpm(buf);
        this.inPrivate = TPM2B_PRIVATE.fromTpm(buf);
        int _inPublicSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _inPublicSize));
        this.inPublic = TPMT_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_Load_REQUEST fromTpm(byte[] x) {
        TPM2_Load_REQUEST ret = new TPM2_Load_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_Load_REQUEST fromTpm(InByteBuf buf) {
        TPM2_Load_REQUEST ret = new TPM2_Load_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Load_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "parentHandle", this.parentHandle);
        _p.add(d, "TPM2B_PRIVATE", "inPrivate", this.inPrivate);
        _p.add(d, "TPMT_PUBLIC", "inPublic", this.inPublic);
    }
}

