/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicySecret_REQUEST
extends TpmStructure {
    public TPM_HANDLE authHandle;
    public TPM_HANDLE policySession;
    public byte[] nonceTPM;
    public byte[] cpHashA;
    public byte[] policyRef;
    public int expiration;

    public TPM2_PolicySecret_REQUEST(TPM_HANDLE _authHandle, TPM_HANDLE _policySession, byte[] _nonceTPM, byte[] _cpHashA, byte[] _policyRef, int _expiration) {
        this.authHandle = _authHandle;
        this.policySession = _policySession;
        this.nonceTPM = _nonceTPM;
        this.cpHashA = _cpHashA;
        this.policyRef = _policyRef;
        this.expiration = _expiration;
    }

    public TPM2_PolicySecret_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.authHandle.toTpm(buf);
        this.policySession.toTpm(buf);
        buf.writeInt(this.nonceTPM != null ? this.nonceTPM.length : 0, 2);
        buf.write(this.nonceTPM);
        buf.writeInt(this.cpHashA != null ? this.cpHashA.length : 0, 2);
        buf.write(this.cpHashA);
        buf.writeInt(this.policyRef != null ? this.policyRef.length : 0, 2);
        buf.write(this.policyRef);
        buf.write(this.expiration);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.authHandle = TPM_HANDLE.fromTpm(buf);
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _nonceTPMSize = buf.readInt(2);
        this.nonceTPM = new byte[_nonceTPMSize];
        buf.readArrayOfInts(this.nonceTPM, 1, _nonceTPMSize);
        int _cpHashASize = buf.readInt(2);
        this.cpHashA = new byte[_cpHashASize];
        buf.readArrayOfInts(this.cpHashA, 1, _cpHashASize);
        int _policyRefSize = buf.readInt(2);
        this.policyRef = new byte[_policyRefSize];
        buf.readArrayOfInts(this.policyRef, 1, _policyRefSize);
        this.expiration = buf.readInt(4);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicySecret_REQUEST fromTpm(byte[] x) {
        TPM2_PolicySecret_REQUEST ret = new TPM2_PolicySecret_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicySecret_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicySecret_REQUEST ret = new TPM2_PolicySecret_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicySecret_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authHandle", this.authHandle);
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "nonceTPM", this.nonceTPM);
        _p.add(d, "byte", "cpHashA", this.cpHashA);
        _p.add(d, "byte", "policyRef", this.policyRef);
        _p.add(d, "int", "expiration", this.expiration);
    }
}

