/*
 * Decompiled with CFR 0.152.
 */
package tss;

import tss.Tpm;
import tss.TpmDeviceBase;
import tss.TpmDeviceLinux;
import tss.TpmDeviceTbs;
import tss.TpmDeviceTcp;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_RH;
import tss.tpm.TPM_SU;

public class TpmFactory {
    public static Tpm localTpmSimulator() {
        Tpm tpm = new Tpm();
        TpmDeviceTcp device = new TpmDeviceTcp("localhost", 2321);
        ((TpmDeviceBase)device).powerCycle();
        tpm = new Tpm();
        tpm._setDevice(device);
        tpm.Startup(TPM_SU.CLEAR);
        tpm.DictionaryAttackLockReset(TPM_HANDLE.from(TPM_RH.LOCKOUT));
        return tpm;
    }

    public static Tpm remoteTpm(String hostName, int port) {
        Tpm tpm = new Tpm();
        TpmDeviceTcp device = new TpmDeviceTcp(hostName, port);
        tpm._setDevice(device);
        return tpm;
    }

    public static Tpm platformTpm() {
        Tpm tpm = new Tpm();
        String osName = System.getProperty("os.name");
        TpmDeviceBase device = null;
        if (osName.contains("Windows")) {
            device = new TpmDeviceTbs();
        } else {
            try {
                device = new TpmDeviceLinux();
            }
            catch (Exception e) {
                device = new TpmDeviceTcp("localhost", 2323, true);
            }
        }
        tpm._setDevice(device);
        return tpm;
    }
}

