/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ECC_POINT;

public class ECDH_KeyGenResponse
extends TpmStructure {
    public TPMS_ECC_POINT zPoint;
    public TPMS_ECC_POINT pubPoint;

    public ECDH_KeyGenResponse(TPMS_ECC_POINT _zPoint, TPMS_ECC_POINT _pubPoint) {
        this.zPoint = _zPoint;
        this.pubPoint = _pubPoint;
    }

    public ECDH_KeyGenResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.zPoint != null ? this.zPoint.toTpm().length : 0, 2);
        if (this.zPoint != null) {
            this.zPoint.toTpm(buf);
        }
        buf.writeInt(this.pubPoint != null ? this.pubPoint.toTpm().length : 0, 2);
        if (this.pubPoint != null) {
            this.pubPoint.toTpm(buf);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _zPointSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _zPointSize));
        this.zPoint = TPMS_ECC_POINT.fromTpm(buf);
        buf.structSize.pop();
        int _pubPointSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack2 = buf.structSize;
        InByteBuf inByteBuf2 = buf;
        inByteBuf2.getClass();
        stack2.push(inByteBuf2.new InByteBuf.SizedStructInfo(buf.curPos(), _pubPointSize));
        this.pubPoint = TPMS_ECC_POINT.fromTpm(buf);
        buf.structSize.pop();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static ECDH_KeyGenResponse fromTpm(byte[] x) {
        ECDH_KeyGenResponse ret = new ECDH_KeyGenResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static ECDH_KeyGenResponse fromTpm(InByteBuf buf) {
        ECDH_KeyGenResponse ret = new ECDH_KeyGenResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_ECDH_KeyGen_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_ECC_POINT", "zPoint", this.zPoint);
        _p.add(d, "TPMS_ECC_POINT", "pubPoint", this.pubPoint);
    }
}

