/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class NV_ReadResponse
extends TpmStructure {
    public byte[] data;

    public NV_ReadResponse(byte[] _data) {
        this.data = _data;
    }

    public NV_ReadResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.data != null ? this.data.length : 0, 2);
        if (this.data != null) {
            buf.write(this.data);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _dataSize = buf.readInt(2);
        this.data = new byte[_dataSize];
        buf.readArrayOfInts(this.data, 1, _dataSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static NV_ReadResponse fromTpm(byte[] x) {
        NV_ReadResponse ret = new NV_ReadResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static NV_ReadResponse fromTpm(InByteBuf buf) {
        NV_ReadResponse ret = new NV_ReadResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_NV_Read_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "data", this.data);
    }
}

