/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ECC_POINT;
import tss.tpm.TPM_HANDLE;

public class TPM2_ECDH_ZGen_REQUEST
extends TpmStructure {
    public TPM_HANDLE keyHandle;
    public TPMS_ECC_POINT inPoint;

    public TPM2_ECDH_ZGen_REQUEST(TPM_HANDLE _keyHandle, TPMS_ECC_POINT _inPoint) {
        this.keyHandle = _keyHandle;
        this.inPoint = _inPoint;
    }

    public TPM2_ECDH_ZGen_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.keyHandle.toTpm(buf);
        buf.writeInt(this.inPoint != null ? this.inPoint.toTpm().length : 0, 2);
        if (this.inPoint != null) {
            this.inPoint.toTpm(buf);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.keyHandle = TPM_HANDLE.fromTpm(buf);
        int _inPointSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _inPointSize));
        this.inPoint = TPMS_ECC_POINT.fromTpm(buf);
        buf.structSize.pop();
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_ECDH_ZGen_REQUEST fromTpm(byte[] x) {
        TPM2_ECDH_ZGen_REQUEST ret = new TPM2_ECDH_ZGen_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_ECDH_ZGen_REQUEST fromTpm(InByteBuf buf) {
        TPM2_ECDH_ZGen_REQUEST ret = new TPM2_ECDH_ZGen_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_ECDH_ZGen_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "TPMS_ECC_POINT", "inPoint", this.inPoint);
    }
}

