/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SENSITIVE;
import tss.tpm.TPM_HANDLE;

public class TPM2_LoadExternal_REQUEST
extends TpmStructure {
    public TPMT_SENSITIVE inPrivate;
    public TPMT_PUBLIC inPublic;
    public TPM_HANDLE hierarchy;

    public TPM2_LoadExternal_REQUEST(TPMT_SENSITIVE _inPrivate, TPMT_PUBLIC _inPublic, TPM_HANDLE _hierarchy) {
        this.inPrivate = _inPrivate;
        this.inPublic = _inPublic;
        this.hierarchy = _hierarchy;
    }

    public TPM2_LoadExternal_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.inPrivate != null ? this.inPrivate.toTpm().length : 0, 2);
        if (this.inPrivate != null) {
            this.inPrivate.toTpm(buf);
        }
        buf.writeInt(this.inPublic != null ? this.inPublic.toTpm().length : 0, 2);
        if (this.inPublic != null) {
            this.inPublic.toTpm(buf);
        }
        this.hierarchy.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _inPrivateSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _inPrivateSize));
        this.inPrivate = TPMT_SENSITIVE.fromTpm(buf);
        buf.structSize.pop();
        int _inPublicSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack2 = buf.structSize;
        InByteBuf inByteBuf2 = buf;
        inByteBuf2.getClass();
        stack2.push(inByteBuf2.new InByteBuf.SizedStructInfo(buf.curPos(), _inPublicSize));
        this.inPublic = TPMT_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
        this.hierarchy = TPM_HANDLE.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_LoadExternal_REQUEST fromTpm(byte[] x) {
        TPM2_LoadExternal_REQUEST ret = new TPM2_LoadExternal_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_LoadExternal_REQUEST fromTpm(InByteBuf buf) {
        TPM2_LoadExternal_REQUEST ret = new TPM2_LoadExternal_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_LoadExternal_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_SENSITIVE", "inPrivate", this.inPrivate);
        _p.add(d, "TPMT_PUBLIC", "inPublic", this.inPublic);
        _p.add(d, "TPM_HANDLE", "hierarchy", this.hierarchy);
    }
}

