/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SIGNATURE;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SIGNATURE_ECDAA;
import tss.tpm.TPMS_SIGNATURE_ECDSA;
import tss.tpm.TPMS_SIGNATURE_ECSCHNORR;
import tss.tpm.TPMS_SIGNATURE_RSAPSS;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMS_SIGNATURE_SM2;
import tss.tpm.TPMT_HA;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicySigned_REQUEST
extends TpmStructure {
    public TPM_HANDLE authObject;
    public TPM_HANDLE policySession;
    public byte[] nonceTPM;
    public byte[] cpHashA;
    public byte[] policyRef;
    public int expiration;
    public TPMU_SIGNATURE auth;

    public TPM2_PolicySigned_REQUEST(TPM_HANDLE _authObject, TPM_HANDLE _policySession, byte[] _nonceTPM, byte[] _cpHashA, byte[] _policyRef, int _expiration, TPMU_SIGNATURE _auth) {
        this.authObject = _authObject;
        this.policySession = _policySession;
        this.nonceTPM = _nonceTPM;
        this.cpHashA = _cpHashA;
        this.policyRef = _policyRef;
        this.expiration = _expiration;
        this.auth = _auth;
    }

    public TPM2_PolicySigned_REQUEST() {
    }

    public int GetUnionSelector_auth() {
        if (this.auth instanceof TPMS_SIGNATURE_RSASSA) {
            return 20;
        }
        if (this.auth instanceof TPMS_SIGNATURE_RSAPSS) {
            return 22;
        }
        if (this.auth instanceof TPMS_SIGNATURE_ECDSA) {
            return 24;
        }
        if (this.auth instanceof TPMS_SIGNATURE_ECDAA) {
            return 26;
        }
        if (this.auth instanceof TPMS_SIGNATURE_SM2) {
            return 27;
        }
        if (this.auth instanceof TPMS_SIGNATURE_ECSCHNORR) {
            return 28;
        }
        if (this.auth instanceof TPMT_HA) {
            return 5;
        }
        if (this.auth instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.auth instanceof TPMS_NULL_SIGNATURE) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.authObject.toTpm(buf);
        this.policySession.toTpm(buf);
        buf.writeInt(this.nonceTPM != null ? this.nonceTPM.length : 0, 2);
        if (this.nonceTPM != null) {
            buf.write(this.nonceTPM);
        }
        buf.writeInt(this.cpHashA != null ? this.cpHashA.length : 0, 2);
        if (this.cpHashA != null) {
            buf.write(this.cpHashA);
        }
        buf.writeInt(this.policyRef != null ? this.policyRef.length : 0, 2);
        if (this.policyRef != null) {
            buf.write(this.policyRef);
        }
        buf.write(this.expiration);
        buf.writeInt(this.GetUnionSelector_auth(), 2);
        this.auth.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.authObject = TPM_HANDLE.fromTpm(buf);
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _nonceTPMSize = buf.readInt(2);
        this.nonceTPM = new byte[_nonceTPMSize];
        buf.readArrayOfInts(this.nonceTPM, 1, _nonceTPMSize);
        int _cpHashASize = buf.readInt(2);
        this.cpHashA = new byte[_cpHashASize];
        buf.readArrayOfInts(this.cpHashA, 1, _cpHashASize);
        int _policyRefSize = buf.readInt(2);
        this.policyRef = new byte[_policyRefSize];
        buf.readArrayOfInts(this.policyRef, 1, _policyRefSize);
        this.expiration = buf.readInt(4);
        int _authSigAlg = buf.readInt(2);
        this.auth = null;
        if (_authSigAlg == TPM_ALG_ID.RSASSA.toInt()) {
            this.auth = new TPMS_SIGNATURE_RSASSA();
        } else if (_authSigAlg == TPM_ALG_ID.RSAPSS.toInt()) {
            this.auth = new TPMS_SIGNATURE_RSAPSS();
        } else if (_authSigAlg == TPM_ALG_ID.ECDSA.toInt()) {
            this.auth = new TPMS_SIGNATURE_ECDSA();
        } else if (_authSigAlg == TPM_ALG_ID.ECDAA.toInt()) {
            this.auth = new TPMS_SIGNATURE_ECDAA();
        } else if (_authSigAlg == TPM_ALG_ID.ANY.toInt()) {
            this.auth = new TPMS_SCHEME_HASH();
        } else if (_authSigAlg == TPM_ALG_ID.NULL.toInt()) {
            this.auth = new TPMS_NULL_SIGNATURE();
        }
        if (this.auth == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_authSigAlg).name());
        }
        this.auth.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicySigned_REQUEST fromTpm(byte[] x) {
        TPM2_PolicySigned_REQUEST ret = new TPM2_PolicySigned_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicySigned_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicySigned_REQUEST ret = new TPM2_PolicySigned_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicySigned_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "authObject", this.authObject);
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "nonceTPM", this.nonceTPM);
        _p.add(d, "byte", "cpHashA", this.cpHashA);
        _p.add(d, "byte", "policyRef", this.policyRef);
        _p.add(d, "int", "expiration", this.expiration);
        _p.add(d, "TPMU_SIGNATURE", "auth", this.auth);
    }
}

