/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_PUBLIC;

public class TSS_KEY
extends TpmStructure {
    public TPMT_PUBLIC publicPart;
    public byte[] privatePart;

    public TSS_KEY(TPMT_PUBLIC _publicPart, byte[] _privatePart) {
        this.publicPart = _publicPart;
        this.privatePart = _privatePart;
    }

    public TSS_KEY() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.publicPart.toTpm(buf);
        buf.writeInt(this.privatePart != null ? this.privatePart.length : 0, 2);
        if (this.privatePart != null) {
            buf.write(this.privatePart);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.publicPart = TPMT_PUBLIC.fromTpm(buf);
        int _privatePartSize = buf.readInt(2);
        this.privatePart = new byte[_privatePartSize];
        buf.readArrayOfInts(this.privatePart, 1, _privatePartSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TSS_KEY fromTpm(byte[] x) {
        TSS_KEY ret = new TSS_KEY();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TSS_KEY fromTpm(InByteBuf buf) {
        TSS_KEY ret = new TSS_KEY();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TSS_KEY");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_PUBLIC", "publicPart", this.publicPart);
        _p.add(d, "byte", "privatePart", this.privatePart);
    }
}

