/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizool.technology.sql.jooq;

import com.github.mizool.core.exception.CodeInconsistencyException;
import lombok.NonNull;
import org.jooq.ConnectionProvider;
import org.jooq.SQLDialect;

public abstract class MizoolConnectionProvider
implements ConnectionProvider {
    private final SQLDialect sqlDialect;

    protected MizoolConnectionProvider(@NonNull String driverClassName, @NonNull SQLDialect sqlDialect) {
        if (driverClassName == null) {
            throw new NullPointerException("driverClassName is marked non-null but is null");
        }
        if (sqlDialect == null) {
            throw new NullPointerException("sqlDialect is marked non-null but is null");
        }
        this.sqlDialect = sqlDialect;
        System.setProperty("org.jooq.no-logo", "true");
        this.loadDriver(driverClassName);
    }

    private void loadDriver(String driverClassName) {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new CodeInconsistencyException("JDBC driver '" + driverClassName + "' is missing on classpath", (Throwable)e);
        }
    }

    public SQLDialect getSqlDialect() {
        return this.sqlDialect;
    }
}

