/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi;

import com.github.mob41.blapi.A1Device;
import com.github.mob41.blapi.FloureonDevice;
import com.github.mob41.blapi.HysenDevice;
import com.github.mob41.blapi.MP1Device;
import com.github.mob41.blapi.RM2Device;
import com.github.mob41.blapi.SP1Device;
import com.github.mob41.blapi.SP2Device;
import com.github.mob41.blapi.mac.Mac;
import com.github.mob41.blapi.pkt.CmdPacket;
import com.github.mob41.blapi.pkt.CmdPayload;
import com.github.mob41.blapi.pkt.Packet;
import com.github.mob41.blapi.pkt.auth.AES;
import com.github.mob41.blapi.pkt.auth.AuthCmdPayload;
import com.github.mob41.blapi.pkt.dis.DiscoveryPacket;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BLDevice
implements Closeable {
    protected static final Logger log = LoggerFactory.getLogger(BLDevice.class);
    public static final byte[] INITIAL_KEY = new byte[]{9, 118, 40, 52, 63, -23, -98, 35, 118, 92, 21, 19, -84, -49, -117, 2};
    public static final byte[] INITIAL_IV = new byte[]{86, 46, 23, -103, 109, 9, 61, 40, -35, -77, -70, 105, 90, 46, 111, 88};
    public static final int DEFAULT_BYTES_SIZE = 56;
    public static final short DEV_SP1 = 0;
    public static final short DEV_SP2 = 10001;
    public static final short DEV_SP2_HONEYWELL_ALT1 = 10009;
    public static final short DEV_SP2_HONEYWELL_ALT2 = 31001;
    public static final short DEV_SP2_HONEYWELL_ALT3 = 10010;
    public static final short DEV_SP2_HONEYWELL_ALT4 = 31002;
    public static final short DEV_SPMINI = 10016;
    public static final short DEV_SP3 = 30014;
    public static final short DEV_SPMINI2 = 10024;
    public static final short DEV_SPMINI_OEM_ALT1 = 10035;
    public static final short DEV_SPMINI_OEM_ALT2 = 10046;
    public static final short DEV_SPMINI_PLUS = 10038;
    public static final short DEV_RM_2 = 10002;
    public static final short DEV_RM_MINI = 10039;
    public static final short DEV_RM_PRO_PHICOMM = 10045;
    public static final short DEV_RM_2_HOME_PLUS = 10115;
    public static final short DEV_RM_2_2HOME_PLUS_GDT = 10108;
    public static final short DEV_RM_2_PRO_PLUS = 10026;
    public static final short DEV_RM_2_PRO_PLUS_2 = 10119;
    public static final short DEV_RM_2_PRO_PLUS_2_BL = 10123;
    public static final short DEV_RM_MINI_SHATE = 10127;
    public static final short DEV_A1 = 10004;
    public static final short DEV_MP1 = 20149;
    public static final short DEV_HYSEN = 20141;
    public static final short DEV_FLOUREON = -83;
    public static final String DESC_UNKNOWN = "Unknown Device";
    public static final String DESC_RM_2 = "RM 2";
    public static final String DESC_RM_MINI = "RM Mini";
    public static final String DESC_RM_PRO_PHICOMM = "RM Pro";
    public static final String DESC_RM_2_HOME_PLUS = "RM 2 Home Plus";
    public static final String DESC_RM_2_2HOME_PLUS_GDT = "RM 2 Home Plus GDT";
    public static final String DESC_RM_2_PRO_PLUS = "RM 2 Pro Plus";
    public static final String DESC_RM_2_PRO_PLUS_2 = "RM 2 Pro Plus 2";
    public static final String DESC_RM_2_PRO_PLUS_2_BL = "RM 2 Pro Plus 2 BL";
    public static final String DESC_RM_MINI_SHATE = "RM Mini SHATE";
    public static final String DESC_A1 = "Environmental Sensor";
    public static final String DESC_MP1 = "Power Strip";
    public static final String DESC_SP1 = "Smart Plug V1";
    public static final String DESC_SP2 = "Smart Plug V2";
    public static final String DESC_SP2_HONEYWELL_ALT1 = "Smart Plug Honeywell Alt 1";
    public static final String DESC_SP2_HONEYWELL_ALT2 = "Smart Plug Honeywell Alt 2";
    public static final String DESC_SP2_HONEYWELL_ALT3 = "Smart Plug Honeywell Alt 3";
    public static final String DESC_SP2_HONEYWELL_ALT4 = "Smart Plug Honeywell Alt 4";
    public static final String DESC_SPMINI = "Smart Plug Mini";
    public static final String DESC_SP3 = "Smart Plug V3";
    public static final String DESC_SPMINI2 = "Smart Plug Mini V2";
    public static final String DESC_SPMINI_OEM_ALT1 = "Smart Plug OEM Alt 1";
    public static final String DESC_SPMINI_OEM_ALT2 = "Smart Plug OEM Alt 2";
    public static final String DESC_SPMINI_PLUS = "Smart Plug Mini Plus";
    public static final String DESC_HYSEN = "Hysen Thermostat";
    public static final String DESC_FLOUREON = "Floureon Thermostat";
    public static final int DISCOVERY_DEST_PORT = 80;
    public static final int DISCOVERY_RECEIVE_BUFFER_SIZE = 64;
    public static final int DEFAULT_TIMEOUT = 10000;
    private int pktCount;
    private byte[] key = INITIAL_KEY;
    private byte[] iv = INITIAL_IV;
    private byte[] id = new byte[]{0, 0, 0, 0};
    private final short deviceType;
    private final String deviceDesc;
    private DatagramSocket sock;
    private String host;
    private Mac mac;
    private AES aes = null;
    private boolean alreadyAuthorized;

    protected BLDevice(short deviceType, String deviceDesc, String host, Mac mac) throws IOException {
        this.pktCount = new Random().nextInt(65535);
        this.deviceType = deviceType;
        this.deviceDesc = deviceDesc;
        this.host = host;
        this.mac = mac;
        this.sock = new DatagramSocket();
        this.sock.setReuseAddress(true);
        this.sock.setBroadcast(true);
        this.aes = new AES(this.iv, this.key);
        this.alreadyAuthorized = false;
    }

    @Override
    public void close() {
        this.sock.close();
    }

    public short getDeviceType() {
        return this.deviceType;
    }

    public String getHost() {
        return this.host;
    }

    public Mac getMac() {
        return this.mac;
    }

    public AES getAes() {
        return this.aes;
    }

    public String getDeviceDescription() {
        return this.deviceDesc;
    }

    public boolean auth() throws IOException {
        return this.auth(false);
    }

    public boolean auth(boolean reauth) throws IOException {
        log.debug("auth Authentication method starts");
        if (this.alreadyAuthorized && !reauth) {
            log.debug("auth Already Authorized.");
            return true;
        }
        AuthCmdPayload sendPayload = new AuthCmdPayload();
        log.debug("auth Sending CmdPacket with AuthCmdPayload: cmd=" + Integer.toHexString(sendPayload.getCommand()) + " len=" + sendPayload.getPayload().getData().length);
        log.debug("auth AuthPayload initial bytes to send: {}", (Object)DatatypeConverter.printHexBinary((byte[])sendPayload.getPayload().getData()));
        DatagramPacket recvPack = this.sendCmdPkt(10000, 2048, sendPayload);
        byte[] data = recvPack.getData();
        if (data.length <= 0) {
            log.error("auth Received 0 bytes on initial request.");
            this.alreadyAuthorized = false;
            return false;
        }
        log.debug("auth recv encrypted data bytes (" + data.length + ") after initial req: {}", (Object)DatatypeConverter.printHexBinary((byte[])data));
        byte[] payload = null;
        try {
            log.debug("auth Decrypting encrypted data");
            payload = this.decryptFromDeviceMessage(data);
            log.debug("auth Decrypted. len=" + payload.length);
        }
        catch (Exception e) {
            log.error("auth Received datagram decryption error. Aborting method", (Throwable)e);
            this.alreadyAuthorized = false;
            return false;
        }
        log.debug("auth Packet received payload bytes: " + DatatypeConverter.printHexBinary((byte[])payload));
        this.key = BLDevice.subbytes(payload, 4, 20);
        log.debug("auth Packet received key bytes: " + DatatypeConverter.printHexBinary((byte[])this.key));
        if (this.key.length % 16 != 0) {
            log.error("auth Received key len is not a multiple of 16! Aborting");
            this.alreadyAuthorized = false;
            return false;
        }
        this.aes = new AES(this.iv, this.key);
        this.id = BLDevice.subbytes(payload, 0, 4);
        log.debug("auth Packet received id bytes: " + DatatypeConverter.printHexBinary((byte[])this.id) + " with ID len=" + this.id.length);
        log.debug("auth End of authentication method");
        this.alreadyAuthorized = true;
        return true;
    }

    public DatagramPacket sendCmdPkt(CmdPayload cmdPayload) throws IOException {
        return this.sendCmdPkt(10000, cmdPayload);
    }

    public DatagramPacket sendCmdPkt(int timeout, CmdPayload cmdPayload) throws IOException {
        return this.sendCmdPkt(InetAddress.getLocalHost(), 0, timeout, 1024, cmdPayload);
    }

    public DatagramPacket sendCmdPkt(int timeout, int bufSize, CmdPayload cmdPayload) throws IOException {
        return this.sendCmdPkt(InetAddress.getLocalHost(), 0, timeout, bufSize, cmdPayload);
    }

    public DatagramPacket sendCmdPkt(InetAddress sourceIpAddr, int sourcePort, int timeout, int bufSize, CmdPayload cmdPayload) throws IOException {
        CmdPacket cmdPkt = new CmdPacket(this.mac, this.pktCount++, this.id, this.aes, cmdPayload);
        log.debug("sendCmdPkt - Send Command Packet bytes: {}", (Object)DatatypeConverter.printHexBinary((byte[])cmdPkt.getData()));
        return BLDevice.sendPkt(this.sock, cmdPkt, InetAddress.getByName(this.host), 80, timeout, bufSize);
    }

    public static BLDevice createInstance(short deviceType, String host, Mac mac) throws IOException {
        String desc = BLDevice.getDescOfType(deviceType);
        switch (deviceType) {
            case 0: {
                return new SP1Device(host, mac);
            }
            case 10001: 
            case 10009: 
            case 10010: 
            case 10016: 
            case 10024: 
            case 10035: 
            case 10038: 
            case 10046: 
            case 30014: 
            case 31001: 
            case 31002: {
                return new SP2Device(deviceType, desc, host, mac);
            }
            case 10002: 
            case 10026: 
            case 10039: 
            case 10045: 
            case 10108: 
            case 10115: 
            case 10119: 
            case 10123: 
            case 10127: {
                return new RM2Device(deviceType, desc, host, mac);
            }
            case 10004: {
                return new A1Device(host, mac);
            }
            case 20149: {
                return new MP1Device(host, mac);
            }
            case -83: {
                return new FloureonDevice(host, mac);
            }
            case 20141: {
                return new HysenDevice(host, mac);
            }
        }
        return null;
    }

    public static BLDevice[] discoverDevices() throws IOException {
        return BLDevice.discoverDevices(10000);
    }

    public static BLDevice[] discoverDevices(int timeout) throws IOException {
        return BLDevice.discoverDevices(InetAddress.getLocalHost(), 0, timeout);
    }

    public static BLDevice[] discoverDevices(InetAddress sourceIpAddr, int sourcePort, int timeout) throws IOException {
        DatagramSocket sock;
        ArrayList<BLDevice> devices;
        boolean debug;
        block22: {
            long elapsed;
            DatagramPacket recePacket;
            byte[] receBytes;
            block20: {
                block21: {
                    debug = log.isDebugEnabled();
                    if (debug) {
                        log.debug("Discovering devices");
                    }
                    devices = new ArrayList<BLDevice>(50);
                    if (debug) {
                        log.debug("Constructing DiscoveryPacket");
                    }
                    DiscoveryPacket dpkt = new DiscoveryPacket(sourceIpAddr, sourcePort);
                    sock = new DatagramSocket(sourcePort, sourceIpAddr);
                    sock.setBroadcast(true);
                    sock.setReuseAddress(true);
                    byte[] sendBytes = dpkt.getData();
                    DatagramPacket sendpack = new DatagramPacket(sendBytes, sendBytes.length, InetAddress.getByName("255.255.255.255"), 80);
                    if (debug) {
                        log.debug("Sending broadcast");
                    }
                    sock.send(sendpack);
                    receBytes = new byte[64];
                    recePacket = new DatagramPacket(receBytes, 0, receBytes.length);
                    if (timeout != 0) break block20;
                    if (debug) {
                        log.debug("No timeout was set. Blocking thread until received");
                    }
                    log.debug("Waiting for datagrams");
                    sock.receive(recePacket);
                    if (debug) {
                        log.debug("Received. Closing socket");
                    }
                    sock.close();
                    String host = recePacket.getAddress().getHostAddress();
                    Mac mac = new Mac(BLDevice.subbytes(receBytes, 58, 64));
                    short deviceType = (short)(receBytes[52] | receBytes[53] << 8);
                    if (debug) {
                        log.debug("Info: host=" + host + " mac=" + mac.getMacString() + " deviceType=0x" + Integer.toHexString(deviceType));
                    }
                    log.debug("Creating BLDevice instance");
                    BLDevice inst = BLDevice.createInstance(deviceType, host, mac);
                    if (inst == null) break block21;
                    if (debug) {
                        log.debug("Adding to found devices list");
                    }
                    devices.add(inst);
                    break block22;
                }
                if (!debug) break block22;
                log.debug("Cannot create instance, returned null, not adding to found devices list");
                break block22;
            }
            if (debug) {
                log.debug("A timeout of " + timeout + " ms was set. Running loop");
            }
            long startTime = System.currentTimeMillis();
            while ((elapsed = System.currentTimeMillis() - startTime) < (long)timeout) {
                if (debug) {
                    log.debug("Elapsed: " + elapsed + " ms");
                }
                log.debug("Socket timeout: timeout-elapsed=" + ((long)timeout - elapsed));
                sock.setSoTimeout((int)((long)timeout - elapsed));
                try {
                    if (debug) {
                        log.debug("Waiting for datagrams");
                    }
                    sock.receive(recePacket);
                }
                catch (SocketTimeoutException e) {
                    if (!debug) break;
                    log.debug("Socket timed out for " + ((long)timeout - elapsed) + " ms", (Throwable)e);
                    break;
                }
                if (debug) {
                    log.debug("Received datagram");
                }
                String host = recePacket.getAddress().getHostAddress();
                Mac mac = new Mac(BLDevice.reverseBytes(BLDevice.subbytes(receBytes, 58, 64)));
                short deviceType = (short)(receBytes[52] | receBytes[53] << 8);
                if (debug) {
                    log.debug("Info: host=" + host + " mac=" + mac.getMacString() + " deviceType=0x" + Integer.toHexString(deviceType));
                }
                log.debug("Creating BLDevice instance");
                BLDevice inst = BLDevice.createInstance(deviceType, host, mac);
                if (inst != null) {
                    if (debug) {
                        log.debug("Adding to found devices list");
                    }
                    devices.add(inst);
                    continue;
                }
                if (!debug) continue;
                log.debug("Cannot create instance, returned null, not adding to found devices list");
            }
        }
        if (debug) {
            log.debug("Converting list to array: " + devices.size());
        }
        BLDevice[] out = new BLDevice[devices.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (BLDevice)devices.get(i);
        }
        if (debug) {
            log.debug("End of device discovery: " + out.length);
        }
        sock.close();
        return out;
    }

    public static String getDescOfType(short devType) {
        switch (devType) {
            case 10002: {
                return DESC_RM_2;
            }
            case 10039: {
                return DESC_RM_MINI;
            }
            case 10045: {
                return DESC_RM_PRO_PHICOMM;
            }
            case 10115: {
                return DESC_RM_2_HOME_PLUS;
            }
            case 10108: {
                return DESC_RM_2_2HOME_PLUS_GDT;
            }
            case 10026: {
                return DESC_RM_2_PRO_PLUS;
            }
            case 10119: {
                return DESC_RM_2_PRO_PLUS_2;
            }
            case 10123: {
                return DESC_RM_2_PRO_PLUS_2_BL;
            }
            case 10127: {
                return DESC_RM_MINI_SHATE;
            }
            case 10001: {
                return DESC_SP2;
            }
            case 10009: {
                return DESC_SP2_HONEYWELL_ALT1;
            }
            case 31001: {
                return DESC_SP2_HONEYWELL_ALT2;
            }
            case 10010: {
                return DESC_SP2_HONEYWELL_ALT3;
            }
            case 31002: {
                return DESC_SP2_HONEYWELL_ALT4;
            }
            case 30014: {
                return DESC_SP3;
            }
            case 10016: {
                return DESC_SPMINI;
            }
            case 10024: {
                return DESC_SPMINI2;
            }
            case 10035: {
                return DESC_SPMINI_OEM_ALT1;
            }
            case 10046: {
                return DESC_SPMINI_OEM_ALT2;
            }
            case 10038: {
                return DESC_SPMINI_PLUS;
            }
            case 0: {
                return DESC_SP1;
            }
            case 20149: {
                return DESC_MP1;
            }
            case 10004: {
                return DESC_A1;
            }
            case 20141: {
                return DESC_HYSEN;
            }
            case -83: {
                return DESC_FLOUREON;
            }
        }
        return DESC_UNKNOWN;
    }

    public static byte[] reverseBytes(byte[] data) {
        byte[] out = new byte[data.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = data[data.length - 1 - i];
        }
        return out;
    }

    public static byte[] removeNullsFromEnd(byte[] data, int offset) {
        int new_length = 0;
        for (int i = data.length - 1; i >= offset; --i) {
            if (data[i] == 0) continue;
            new_length = i + 1;
            break;
        }
        byte[] out = new byte[new_length];
        for (int x = offset; x < new_length; ++x) {
            out[x - offset] = data[x];
        }
        return out;
    }

    public static byte[] subbytesTillNull(byte[] data, int offset) {
        int new_length = 0;
        for (int i = offset; i < data.length; ++i) {
            if (data[i] != 0) continue;
            new_length = i;
            break;
        }
        byte[] out = new byte[new_length];
        for (int x = offset; x < new_length; ++x) {
            out[x - offset] = data[x];
        }
        return out;
    }

    public byte[] getRawPayloadBytesPadded(byte[] data) {
        byte[] encData = BLDevice.subbytes(data, 56, data.length);
        byte[] newBytes = null;
        if (encData.length > 0) {
            int numpad = 16 - encData.length % 16;
            newBytes = new byte[encData.length + numpad];
            for (int i = 0; i < newBytes.length; ++i) {
                newBytes[i] = i < encData.length ? encData[i] : (byte)0;
            }
        }
        return newBytes;
    }

    protected byte[] decryptFromDeviceMessage(byte[] encData) throws Exception {
        byte[] encPL = this.getRawPayloadBytesPadded(encData);
        byte[] pl = this.aes.decrypt(encPL);
        return pl;
    }

    public static byte[] subbytes(byte[] data, int start, int end) {
        byte[] out = new byte[end - start];
        int outi = 0;
        int i = start;
        while (i < end) {
            out[outi] = data[i];
            ++i;
            ++outi;
        }
        return out;
    }

    public static DatagramPacket sendPkt(Packet pkt, InetAddress sourceIpAddr, int sourcePort, InetAddress destIpAddr, int destPort, int timeout, int bufSize) throws IOException {
        log.debug("sendPkt - call with create socket for: " + sourceIpAddr.getHostAddress() + " and port " + sourcePort);
        DatagramSocket sock = new DatagramSocket(sourcePort, sourceIpAddr);
        sock.setBroadcast(true);
        sock.setReuseAddress(true);
        DatagramPacket recePkt = BLDevice.sendPkt(sock, pkt, destIpAddr, destPort, timeout, bufSize);
        sock.close();
        return recePkt;
    }

    public static DatagramPacket sendPkt(DatagramSocket sock, Packet pkt, InetAddress destIpAddr, int destPort, int timeout, int bufSize) throws IOException {
        long elapsed;
        String boundHost = null;
        boundHost = sock.getInetAddress() == null ? "0.0.0.0" : sock.getInetAddress().getHostAddress();
        log.debug("sendPkt - call with given sock for " + boundHost + " and port " + sock.getPort());
        byte[] data = pkt.getData();
        DatagramPacket sendpack = new DatagramPacket(data, data.length, destIpAddr, destPort);
        log.debug("snedPkt - data for length: " + data.length + " to: " + sendpack.getAddress().getHostAddress() + " for port: " + sendpack.getPort());
        byte[] rece = new byte[bufSize];
        DatagramPacket recepack = new DatagramPacket(rece, 0, rece.length);
        long startTime = System.currentTimeMillis();
        while ((elapsed = System.currentTimeMillis() - startTime) < (long)timeout) {
            try {
                sock.send(sendpack);
                sock.setSoTimeout(1000);
                sock.receive(recepack);
            }
            catch (SocketTimeoutException e) {
                if (elapsed <= (long)timeout) continue;
            }
            break;
        }
        log.debug("sendPkt - recv data bytes (" + recepack.getData().length + ") after initial req: {}", (Object)DatatypeConverter.printHexBinary((byte[])recepack.getData()));
        recepack.setData(BLDevice.removeNullsFromEnd(recepack.getData(), 0));
        return recepack;
    }

    public static byte[] chgLen(byte[] data, int newLen) {
        byte[] newBytes = new byte[newLen];
        for (int i = 0; i < data.length; ++i) {
            newBytes[i] = data[i];
        }
        return newBytes;
    }
}

