/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi;

public class EnvData {
    public static final byte LIGHT_DARK = 0;
    public static final byte LIGHT_DIM = 1;
    public static final byte LIGHT_NORMAL = 2;
    public static final byte LIGHT_BRIGHT = 3;
    public static final byte AIR_QUALITY_EXCELLENT = 0;
    public static final byte AIR_QUALITY_GOOD = 1;
    public static final byte AIR_QUALITY_NORMAL = 2;
    public static final byte AIR_QUALITY_BAD = 3;
    public static final byte NOISE_QUIET = 0;
    public static final byte NOISE_NORMAL = 1;
    public static final byte NOISE_NOISY = 2;
    private final float temp;
    private final float humidity;
    private final byte light;
    private final byte airQuality;
    private final byte noise;

    protected EnvData(float temp, float hum, byte light, byte airQuality, byte noise) {
        this.temp = temp;
        this.humidity = hum;
        this.light = light;
        this.airQuality = airQuality;
        this.noise = noise;
    }

    public float getTemp() {
        return this.temp;
    }

    public float getHumidity() {
        return this.humidity;
    }

    public byte getLight() {
        return this.light;
    }

    public String getLightDescription() {
        switch (this.light) {
            case 0: {
                return "dark";
            }
            case 1: {
                return "dim";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "bright";
            }
        }
        return "unknown";
    }

    public byte getAirQuality() {
        return this.airQuality;
    }

    public String getAirQualityDescription() {
        switch (this.light) {
            case 0: {
                return "excellent";
            }
            case 1: {
                return "good";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "bad";
            }
        }
        return "unknown";
    }

    public byte getNoise() {
        return this.noise;
    }

    public String getNoiseDescription() {
        switch (this.light) {
            case 0: {
                return "quiet";
            }
            case 1: {
                return "normal";
            }
            case 2: {
                return "noisy";
            }
        }
        return "unknown";
    }
}

