/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi;

import com.github.mob41.blapi.BLDevice;
import com.github.mob41.blapi.mac.Mac;
import com.github.mob41.blapi.pkt.CmdPayload;
import com.github.mob41.blapi.pkt.Payload;
import java.io.IOException;
import java.net.DatagramPacket;
import javax.xml.bind.DatatypeConverter;

public class MP1Device
extends BLDevice {
    protected MP1Device(short deviceType, String deviceDesc, String host, Mac mac) throws IOException {
        super(deviceType, deviceDesc, host, mac);
    }

    public MP1Device(String host, Mac mac) throws IOException {
        super((short)20149, "Power Strip", host, mac);
    }

    public void setState(int sid, boolean state) throws Exception {
        int sid_mask = 1 << sid - 1;
        this.setStateMask(sid_mask, state);
    }

    private void setStateMask(final int sid_mask, final boolean state) throws Exception {
        DatagramPacket packet = this.sendCmdPkt(new CmdPayload(){

            @Override
            public byte getCommand() {
                return 106;
            }

            @Override
            public Payload getPayload() {
                return new Payload(){

                    @Override
                    public byte[] getData() {
                        byte[] b = new byte[16];
                        b[0] = 13;
                        b[2] = -91;
                        b[3] = -91;
                        b[4] = 90;
                        b[5] = 90;
                        b[6] = (byte)(178 + (state ? sid_mask << 1 : sid_mask));
                        b[7] = -64;
                        b[8] = 2;
                        b[10] = 3;
                        b[13] = (byte)sid_mask;
                        b[14] = (byte)(state ? sid_mask : 0);
                        return b;
                    }
                };
            }
        });
        byte[] data = packet.getData();
        int err = data[34] | data[35] << 8;
        if (err == 0) {
            log.debug("MP1 set state mask received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        } else {
            log.warn("MP1 set state mask received returned err: " + Integer.toHexString(err) + " / " + err);
        }
    }

    public boolean getStateByIndex(int index) throws Exception {
        return this.getStates()[index];
    }

    public boolean[] getStates() throws Exception {
        byte state = this.getStatesRaw();
        boolean[] data = new boolean[]{(state & 1) != 0, (state & 2) != 0, (state & 4) != 0, (state & 8) != 0};
        return data;
    }

    private byte getStatesRaw() throws Exception {
        DatagramPacket packet = this.sendCmdPkt(new CmdPayload(){

            @Override
            public byte getCommand() {
                return 106;
            }

            @Override
            public Payload getPayload() {
                return new Payload(){

                    @Override
                    public byte[] getData() {
                        byte[] b = new byte[16];
                        b[0] = 10;
                        b[2] = -91;
                        b[3] = -91;
                        b[4] = 90;
                        b[5] = 90;
                        b[6] = -82;
                        b[7] = -64;
                        b[8] = 1;
                        return b;
                    }
                };
            }
        });
        byte[] data = packet.getData();
        log.debug("MP1 get states raw received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        int err = data[34] | data[35] << 8;
        if (err == 0) {
            byte[] pl = this.decryptFromDeviceMessage(data);
            log.debug("MP1 get states raw received bytes (decrypted): " + DatatypeConverter.printHexBinary((byte[])pl));
            byte state = 0;
            if (pl[60] >= 48 && pl[60] <= 57) {
                String decodeValue1 = String.valueOf(pl[70]);
                state = Short.decode(decodeValue1).byteValue();
            } else {
                state = pl[70];
            }
            return state;
        }
        log.warn("MP1 get states raw received an error: " + Integer.toHexString(err) + " / " + err);
        return 0;
    }
}

