/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi;

import com.github.mob41.blapi.BLDevice;
import com.github.mob41.blapi.mac.Mac;
import com.github.mob41.blapi.pkt.cmd.rm2.CheckDataCmdPayload;
import com.github.mob41.blapi.pkt.cmd.rm2.EnterLearnCmdPayload;
import com.github.mob41.blapi.pkt.cmd.rm2.RMTempCmdPayload;
import java.io.IOException;
import java.net.DatagramPacket;
import javax.xml.bind.DatatypeConverter;

public class RM2Device
extends BLDevice {
    protected RM2Device(short deviceType, String deviceDesc, String host, Mac mac) throws IOException {
        super(deviceType, deviceDesc, host, mac);
    }

    public RM2Device(String host, Mac mac) throws IOException {
        super((short)10002, "RM 2", host, mac);
    }

    public byte[] checkData() throws Exception {
        CheckDataCmdPayload cmdPayload = new CheckDataCmdPayload();
        DatagramPacket packet = this.sendCmdPkt(10000, cmdPayload);
        byte[] data = packet.getData();
        int err = data[34] | data[35] << 8;
        log.debug("RM2 check data received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        if (err == 0) {
            byte[] encData = this.decryptFromDeviceMessage(data);
            return RM2Device.subbytes(encData, 4, encData.length);
        }
        log.warn("RM2 check data received error: " + Integer.toHexString(err) + " / " + err);
        return null;
    }

    public boolean enterLearning() throws IOException {
        EnterLearnCmdPayload cmdPayload = new EnterLearnCmdPayload();
        DatagramPacket packet = this.sendCmdPkt(10000, cmdPayload);
        byte[] data = packet.getData();
        log.debug("RM2 enter learning received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        int err = data[34] | data[35] << 8;
        if (err == 0) {
            return true;
        }
        log.warn("RM2 enter learning received error: " + Integer.toHexString(err) + " / " + err);
        return false;
    }

    public double getTemp() throws Exception {
        DatagramPacket packet = this.sendCmdPkt(new RMTempCmdPayload());
        byte[] data = packet.getData();
        log.debug("RM2 get temp received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        int err = data[34] | data[35] << 8;
        if (err == 0) {
            byte[] pl = this.decryptFromDeviceMessage(data);
            log.debug("RM2 get temp received bytes (decrypted): " + DatatypeConverter.printHexBinary((byte[])pl));
            return (double)(pl[4] * 10 + pl[5]) / 10.0;
        }
        log.warn("RM2 get temp received error: " + Integer.toHexString(err) + " / " + err);
        return -1.0;
    }
}

