/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi.dev.hysen;

import com.github.mob41.blapi.dev.hysen.BaseStatusInfo;
import com.github.mob41.blapi.dev.hysen.Period;
import java.util.Arrays;

public class AdvancedStatusInfo
extends BaseStatusInfo {
    private final short hour;
    private final short min;
    private final short sec;
    private final short dayofweek;
    private final Period[] periods = new Period[8];
    private final Period[] weekday = new Period[6];
    private final Period[] weekend = new Period[2];

    protected AdvancedStatusInfo(byte[] payload) {
        super(payload);
        int i;
        this.hour = payload[19];
        this.min = payload[20];
        this.sec = payload[21];
        this.dayofweek = payload[22];
        for (i = 0; i < 6; ++i) {
            this.periods[i] = new Period(i, payload);
            this.weekday[i] = this.periods[i];
        }
        for (i = 6; i <= 7; ++i) {
            this.periods[i] = new Period(i, payload);
            this.weekend[i - 6] = this.periods[i];
        }
    }

    public short getHour() {
        return this.hour;
    }

    public short getMin() {
        return this.min;
    }

    public short getSec() {
        return this.sec;
    }

    public short getDayofweek() {
        return this.dayofweek;
    }

    public Period[] getWeekday() {
        return this.weekday;
    }

    public Period[] getWeekend() {
        return this.weekend;
    }

    public Period[] getPeriods() {
        return this.periods;
    }

    @Override
    public String toString() {
        return "StatusInfo [remote lock=" + this.remoteLock + ",\n power=" + this.power + ",\n active=" + this.active + ",\n manual temperature=" + this.manualTemp + ",\n room temp=" + this.roomTemp + ",\n thermostat temp=" + this.thermostatTemp + ",\n auto_mode=" + this.autoMode + ",\n loop_mode=" + (Object)((Object)this.loopMode) + ",\n SensorControl=" + (Object)((Object)this.sensorControl) + ",\n osv=" + this.osv + ",\n dif=" + this.dif + ",\n svh=" + this.svh + ",\n svl=" + this.svl + ",\n room temp adj=" + this.roomTempAdjustment + ",\n anti freeze=" + (Object)((Object)this.antiFreezing) + ",\n powerOnMemory=" + (Object)((Object)this.powerOnMemory) + ",\n fac?=" + this.fac + ",\n external temp=" + this.externalTemp + ",\n hour=" + this.hour + ",\n min=" + this.min + ",\n sec=" + this.sec + ",\n dayofweek=" + this.dayofweek + ",\n\n weekday=" + Arrays.toString(this.weekday) + ",\n\n weekend=" + Arrays.toString(this.weekend) + "]";
    }
}

