/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi.mac;

import com.github.mob41.blapi.mac.MacFormatException;

public class Mac {
    private final byte[] mac;

    public Mac(byte[] macBytes) throws MacFormatException {
        if (!Mac.isMACValid(macBytes)) {
            throw new MacFormatException(macBytes);
        }
        this.mac = macBytes;
    }

    public Mac(String macStr) throws MacFormatException {
        this.mac = Mac.macStrToBytes(macStr);
    }

    public byte[] getMac() {
        return this.mac;
    }

    public String getMacString() {
        return Mac.bytesToMacStr(this.mac);
    }

    public static byte[] macStrToBytes(String macStr) throws MacFormatException {
        if (macStr == null) {
            throw new MacFormatException(macStr);
        }
        String[] macs = macStr.split(":");
        if (macs.length != 6) {
            throw new MacFormatException(macStr);
        }
        byte[] bout = new byte[6];
        for (int i = 0; i < macs.length; ++i) {
            try {
                Integer hex = Integer.parseInt(macs[i], 16);
                bout[i] = hex.byteValue();
                continue;
            }
            catch (NumberFormatException e) {
                throw new MacFormatException(macStr, e);
            }
        }
        return bout;
    }

    public static boolean isMACValid(byte[] macBytes) {
        return macBytes != null && macBytes.length == 6;
    }

    public static String bytesToMacStr(byte[] macBytes) throws MacFormatException {
        if (!Mac.isMACValid(macBytes)) {
            throw new MacFormatException(macBytes);
        }
        String str = "";
        for (int i = 0; i < macBytes.length; ++i) {
            String hexStr = String.format("%02x", macBytes[i]);
            str = str + hexStr;
            if (i == macBytes.length - 1) continue;
            str = str + ':';
        }
        return str;
    }

    public String toString() {
        return this.getMacString();
    }
}

