/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi.pkt;

import com.github.mob41.blapi.ex.BLApiRuntimeException;
import com.github.mob41.blapi.mac.Mac;
import com.github.mob41.blapi.pkt.CmdPayload;
import com.github.mob41.blapi.pkt.Packet;
import com.github.mob41.blapi.pkt.auth.AES;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdPacket
implements Packet {
    private static final Logger log = LoggerFactory.getLogger(CmdPacket.class);
    private final byte[] data;

    public CmdPacket(Mac targetMac, int count, byte[] id, AES aesInstance, CmdPayload cmdPayload) {
        int i;
        byte cmd = cmdPayload.getCommand();
        byte[] payload = cmdPayload.getPayload().getData();
        log.debug("Constructor CmdPacket starts");
        log.debug("count=" + count + " cmdPayload.cmd=" + Integer.toHexString(cmd) + " payload.len=" + payload.length);
        count = count + 1 & 0xFFFF;
        log.debug("New count: " + count + " (added by 1)");
        log.debug("Creating byte array with data");
        byte[] headerdata = new byte[56];
        for (int i2 = 0; i2 < headerdata.length; ++i2) {
            headerdata[i2] = 0;
        }
        headerdata[0] = 90;
        headerdata[1] = -91;
        headerdata[2] = -86;
        headerdata[3] = 85;
        headerdata[4] = 90;
        headerdata[5] = -91;
        headerdata[6] = -86;
        headerdata[7] = 85;
        headerdata[36] = 42;
        headerdata[37] = 39;
        headerdata[38] = cmd;
        headerdata[40] = (byte)(count & 0xFF);
        headerdata[41] = (byte)(count >> 8);
        byte[] mac = targetMac.getMac();
        headerdata[42] = mac[0];
        headerdata[43] = mac[1];
        headerdata[44] = mac[2];
        headerdata[45] = mac[3];
        headerdata[46] = mac[4];
        headerdata[47] = mac[5];
        headerdata[48] = id[0];
        headerdata[49] = id[1];
        headerdata[50] = id[2];
        headerdata[51] = id[3];
        byte[] payloadPad = null;
        if (payload.length > 0) {
            int numpad = 16 - payload.length % 16;
            payloadPad = new byte[payload.length + numpad];
            for (i = 0; i < payloadPad.length; ++i) {
                payloadPad[i] = i < payload.length ? payload[i] : (byte)0;
            }
        }
        log.debug("Running checksum for un-encrypted payload");
        int checksumpayload = 48815;
        for (i = 0; i < payloadPad.length; ++i) {
            checksumpayload += Byte.toUnsignedInt(payloadPad[i]);
            checksumpayload &= 0xFFFF;
        }
        headerdata[52] = (byte)(checksumpayload & 0xFF);
        headerdata[53] = (byte)(checksumpayload >> 8);
        log.debug("Un-encrypted payload checksum: " + Integer.toHexString(checksumpayload));
        try {
            log.debug("Encrypting payload");
            payload = aesInstance.encrypt(payloadPad);
            log.debug("Encrypted payload bytes: {}", (Object)DatatypeConverter.printHexBinary((byte[])payload));
            log.debug("Encrypted. len=" + payload.length);
        }
        catch (Exception e) {
            log.error("Cannot encrypt payload! Aborting", (Throwable)e);
            throw new BLApiRuntimeException("Cannot encrypt payload", e);
        }
        this.data = new byte[56 + payload.length];
        for (i = 0; i < headerdata.length; ++i) {
            this.data[i] = headerdata[i];
        }
        for (i = 0; i < payload.length; ++i) {
            this.data[i + 56] = payload[i];
        }
        log.debug("Running whole packet checksum");
        int checksumpkt = 48815;
        for (int i3 = 0; i3 < this.data.length; ++i3) {
            checksumpkt += Byte.toUnsignedInt(this.data[i3]);
            checksumpkt &= 0xFFFF;
        }
        log.debug("Whole packet checksum: " + Integer.toHexString(checksumpkt));
        this.data[32] = (byte)(checksumpkt & 0xFF);
        this.data[33] = (byte)(checksumpkt >> 8);
        log.debug("End of CmdPacket constructor");
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

