/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi.pkt.cmd.hysen;

import com.github.mob41.blapi.dev.hysen.BaseHysenDevice;
import com.github.mob41.blapi.pkt.CmdPayload;
import com.github.mob41.blapi.pkt.Crc16;
import com.github.mob41.blapi.pkt.Payload;
import java.net.DatagramPacket;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHysenCommand
implements CmdPayload {
    protected static final Logger log = LoggerFactory.getLogger(BaseHysenCommand.class);

    public byte[] execute(BaseHysenDevice device) throws Exception {
        DatagramPacket packet = device.sendCmdPkt(this);
        byte[] data = packet.getData();
        log.debug(this.getClass().getSimpleName() + " received encrypted bytes: " + DatatypeConverter.printHexBinary((byte[])data));
        int err = data[34] | data[35] << 8;
        if (err == 0) {
            byte[] pl = device.decryptFromDeviceMessage(data);
            log.debug(this.getClass().getSimpleName() + " received bytes (decrypted): " + DatatypeConverter.printHexBinary((byte[])pl));
            return Arrays.copyOfRange(pl, 2, pl.length);
        }
        log.warn(this.getClass().getSimpleName() + " received an error: " + Integer.toHexString(err) + " / " + err);
        return null;
    }

    @Override
    public byte getCommand() {
        return 106;
    }

    @Override
    public Payload getPayload() {
        return new Payload(){

            @Override
            public byte[] getData() {
                byte[] p = BaseHysenCommand.this.getCmdBytes();
                byte[] cmd = new byte[p.length + 4];
                cmd[0] = (byte)(p.length + 2);
                cmd[1] = 0;
                System.arraycopy(p, 0, cmd, 2, p.length);
                int crc = Crc16.getCrc16(p, p.length, 65535);
                cmd[cmd.length - 2] = (byte)(crc & 0xFF);
                cmd[cmd.length - 1] = (byte)(crc >> 8 & 0xFF);
                return cmd;
            }
        };
    }

    protected abstract byte[] getCmdBytes();

    protected static byte getTempByte(double temp) {
        return (byte)((int)(temp * 2.0) & 0xFF);
    }
}

