/*
 * Decompiled with CFR 0.152.
 */
package com.github.mob41.blapi.pkt.dis;

import com.github.mob41.blapi.ex.BLApiRuntimeException;
import com.github.mob41.blapi.pkt.Packet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryPacket
implements Packet {
    public static final int DEFAULT_SOURCE_PORT = 0;
    private static final Logger log = LoggerFactory.getLogger(DiscoveryPacket.class);
    private final byte[] data;

    public DiscoveryPacket() {
        this(null);
    }

    public DiscoveryPacket(InetAddress localIpAddr) {
        this(localIpAddr, 0, Calendar.getInstance(), TimeZone.getDefault());
    }

    public DiscoveryPacket(InetAddress localIpAddr, int sourcePort) {
        this(localIpAddr, sourcePort, Calendar.getInstance(), TimeZone.getDefault());
    }

    public DiscoveryPacket(InetAddress localIpAddr, int sourcePort, Calendar cal, TimeZone tz) {
        log.debug("DiscoveryPacket constructor start");
        log.debug("cal=" + cal.getTimeInMillis() + " tz=" + tz.getID());
        if (localIpAddr == null) {
            log.debug("localIpAddr is null. Calling InetAddress.getLocalHost");
            try {
                localIpAddr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                log.error("Could not relieve local IP address", (Throwable)e);
                throw new BLApiRuntimeException("Could not relieve local IP address", e);
            }
        }
        log.debug("localIpAddr= " + localIpAddr.getHostName() + "/" + localIpAddr.getHostAddress());
        int rawOffset = tz.getRawOffset();
        int tzOffset = rawOffset / 3600;
        log.debug("Raw offset: " + rawOffset);
        log.debug("Calculated offset: getRawOffset/1000/-3600=" + tzOffset);
        int min = cal.get(12);
        int hr = cal.get(10);
        int year = cal.get(1);
        int dayOfWk = DiscoveryPacket.dayOfWeekConv(cal.get(7));
        int dayOfMn = cal.get(5);
        int month = cal.get(2) + 1;
        log.debug("min=" + min + " hr=" + hr);
        log.debug("year=" + year + " dayOfWk=" + dayOfWk);
        log.debug("dayOfMn=" + dayOfMn + " month=" + month);
        byte[] ipAddrBytes = localIpAddr.getAddress();
        this.data = new byte[48];
        if (tzOffset < 0) {
            this.data[8] = (byte)(255 + tzOffset - 1);
            this.data[9] = -1;
            this.data[10] = -1;
            this.data[11] = -1;
            log.debug("tzOffset<0: 0x08=" + Integer.toHexString(255 + tzOffset - 1) + " 0x09-0x0b=0xff");
        } else {
            this.data[8] = (byte)tzOffset;
            this.data[9] = 0;
            this.data[10] = 0;
            this.data[11] = 0;
            log.debug("tzOffset>0: 0x08=" + Integer.toHexString(tzOffset) + " 0x09-0x0b=0x00");
        }
        this.data[12] = (byte)(year & 0xFF);
        this.data[13] = (byte)(year >> 8);
        this.data[14] = (byte)min;
        this.data[15] = (byte)hr;
        this.data[16] = (byte)Integer.parseInt(Integer.toString(year).substring(2, 4));
        this.data[17] = (byte)dayOfWk;
        this.data[18] = (byte)dayOfMn;
        this.data[19] = (byte)month;
        this.data[24] = ipAddrBytes[0];
        this.data[25] = ipAddrBytes[1];
        this.data[26] = ipAddrBytes[2];
        this.data[27] = ipAddrBytes[3];
        this.data[28] = (byte)(sourcePort & 0xFF);
        this.data[29] = (byte)(sourcePort >> 8);
        this.data[38] = 6;
        int checksum = -16721;
        for (int i = 0; i < this.data.length; ++i) {
            checksum = (short)(checksum + (this.data[i] & 0xFF));
        }
        log.debug("checksum=" + Integer.toHexString(checksum));
        this.data[32] = (byte)(checksum & 0xFF);
        this.data[33] = (byte)(checksum >> 8);
        log.debug("DiscoveryPacket constructor end");
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    private static int dayOfWeekConv(int fieldVal) {
        switch (fieldVal) {
            case 1: {
                return 6;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
        }
        return -1;
    }
}

