/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.client;

import com.mpush.api.Client;
import com.mpush.api.ClientListener;
import com.mpush.client.ClientConfig;
import com.mpush.util.thread.ExecutorManager;
import java.util.concurrent.Executor;

final class DefaultClientListener
implements ClientListener {
    private final Executor executor = ExecutorManager.INSTANCE.getDispatchThread();
    private ClientListener listener;

    DefaultClientListener() {
    }

    public void setListener(ClientListener listener) {
        this.listener = listener;
    }

    @Override
    public void onConnected(final Client client) {
        if (this.listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultClientListener.this.listener.onConnected(client);
                }
            });
        }
        client.fastConnect();
    }

    @Override
    public void onDisConnected(final Client client) {
        if (this.listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultClientListener.this.listener.onDisConnected(client);
                }
            });
        }
    }

    @Override
    public void onHandshakeOk(final Client client, final int heartbeat) {
        if (this.listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultClientListener.this.listener.onHandshakeOk(client, heartbeat);
                }
            });
        }
        client.bindUser(ClientConfig.I.getUserId());
    }

    @Override
    public void onReceivePush(Client client, byte[] content) {
        if (this.listener != null) {
            this.listener.onReceivePush(client, content);
        }
    }

    @Override
    public void onKickUser(String deviceId, String userId) {
        if (this.listener != null) {
            this.listener.onKickUser(deviceId, userId);
        }
    }
}

