/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

import android.util.Log;
import java.io.Writer;

public class LogWriter
extends Writer {
    private final String mTag;
    private StringBuilder mBuilder = new StringBuilder(128);

    public LogWriter(String tag) {
        this.mTag = tag;
    }

    @Override
    public void close() {
        this.flushBuilder();
    }

    @Override
    public void flush() {
        this.flushBuilder();
    }

    @Override
    public void write(char[] buf, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            char c = buf[offset + i];
            if (c == '\n') {
                this.flushBuilder();
                continue;
            }
            this.mBuilder.append(c);
        }
    }

    private void flushBuilder() {
        if (this.mBuilder.length() > 0) {
            Log.d(this.mTag, this.mBuilder.toString());
            this.mBuilder.delete(0, this.mBuilder.length());
        }
    }
}

