/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.MarkerManager;

public class Log {
    private static final Logger sLogger = LogManager.getLogger(Log.class);

    public static void d(String tag, String message) {
        sLogger.debug(MarkerManager.getMarker((String)tag), message);
    }

    public static void d(String tag, String message, Throwable t) {
        Log.d(tag, message + '\n' + Log.getStackTraceString(t));
    }

    public static void v(String tag, String message) {
        sLogger.info(MarkerManager.getMarker((String)tag), message);
    }

    public static void v(String tag, String message, Throwable t) {
        Log.v(tag, message + '\n' + Log.getStackTraceString(t));
    }

    public static void i(String tag, String message) {
        Log.v(tag, message);
    }

    public static void i(String tag, String message, Throwable t) {
        Log.i(tag, message + '\n' + Log.getStackTraceString(t));
    }

    public static void w(String tag, String message) {
        sLogger.warn(MarkerManager.getMarker((String)tag), message);
    }

    public static void w(String tag, String message, Throwable t) {
        Log.w(tag, message + '\n' + Log.getStackTraceString(t));
    }

    public static void e(String tag, String message) {
        sLogger.error(MarkerManager.getMarker((String)tag), message);
    }

    public static void e(String tag, String message, Throwable t) {
        Log.e(tag, message + '\n' + Log.getStackTraceString(t));
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

