/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.explorers;

import com.mwt.explorers.Explorer;
import com.mwt.explorers.TauFirstExplorer;
import com.mwt.explorers.utilities.ExplorerInformation;
import com.mwt.explorers.utilities.FixedVariableActionContext;
import org.junit.Assert;
import org.junit.Test;

public class TauFirstExplorerTest {
    private final ExplorerInformation<String> exInfo = new ExplorerInformation(8);
    private final ExplorerInformation<FixedVariableActionContext> varExInfo = new ExplorerInformation(8);

    @Test
    public void fixedPolicyLessThanTau() {
        this.lessThanTau("context", this.exInfo);
    }

    @Test
    public void fixedPolicyGreaterThanTau() {
        this.greaterThanTau("context", this.exInfo);
    }

    @Test
    public void variableActionPolicyLessThanTau() {
        this.lessThanTau(new FixedVariableActionContext(10), this.varExInfo);
    }

    @Test
    public void variableActionPolicyGreaterThanTau() {
        this.greaterThanTau(new FixedVariableActionContext(10), this.varExInfo);
    }

    private <T> void lessThanTau(T context, ExplorerInformation<T> exInfo) {
        TauFirstExplorer explorer = new TauFirstExplorer(exInfo.policy, 3, 10);
        int action = exInfo.mwt.chooseAction((Explorer)explorer, "abc", context);
        junit.framework.Assert.assertEquals((int)7, (int)action);
        junit.framework.Assert.assertEquals((String)("7 abc 0.10000 | " + context), (String)exInfo.recorder.getRecording().trim());
        int secondAction = exInfo.mwt.chooseAction((Explorer)explorer, "abc", context);
        junit.framework.Assert.assertEquals((int)7, (int)secondAction);
        junit.framework.Assert.assertEquals((String)("7 abc 0.10000 | " + context), (String)exInfo.recorder.getRecording().trim());
    }

    private <T> void greaterThanTau(T context, ExplorerInformation<T> exInfo) {
        TauFirstExplorer explorer = new TauFirstExplorer(exInfo.policy, 0, 10);
        exInfo.mwt.chooseAction((Explorer)explorer, "abc", context);
        int action = exInfo.mwt.chooseAction((Explorer)explorer, "abc", context);
        junit.framework.Assert.assertEquals((int)8, (int)action);
        Assert.assertTrue((boolean)exInfo.recorder.getRecording().trim().isEmpty());
        int secondAction = exInfo.mwt.chooseAction((Explorer)explorer, "abc", context);
        junit.framework.Assert.assertEquals((int)8, (int)secondAction);
        Assert.assertTrue((boolean)exInfo.recorder.getRecording().trim().isEmpty());
    }
}

