/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.explorers;

import com.mwt.consumers.ConsumePolicies;
import com.mwt.explorers.Explorer;
import com.mwt.misc.DecisionTuple;
import com.mwt.policies.Policy;
import com.mwt.utilities.PRG;
import java.util.List;

public class BootstrapExplorer<T>
implements Explorer<T>,
ConsumePolicies<T> {
    private List<Policy<T>> policies;
    private boolean explore = true;
    private final int numActions;

    public BootstrapExplorer(List<Policy<T>> policies, int numActions) {
        if (policies.size() < 1) {
            throw new IllegalArgumentException("Must have a non-empty policy list");
        }
        this.policies = policies;
        this.numActions = numActions;
    }

    protected int getNumActions(T context) {
        return this.numActions;
    }

    @Override
    public void updatePolicy(List<Policy<T>> newPolicies) {
        this.policies = newPolicies;
    }

    @Override
    public DecisionTuple chooseAction(long saltedSeed, T context) {
        int numActionsForContext = this.getNumActions(context);
        PRG random = new PRG(saltedSeed);
        int chosenBag = random.uniformInt(0, this.policies.size() - 1);
        int chosenAction = 0;
        float actionProbability = 0.0f;
        if (this.explore) {
            int actionFromBag = 0;
            int[] actionsSelected = new int[numActionsForContext];
            for (int currentBag = 0; currentBag < this.policies.size(); ++currentBag) {
                actionFromBag = this.policies.get(currentBag).chooseAction(context);
                if (actionFromBag <= 0 || actionFromBag > numActionsForContext) {
                    throw new RuntimeException("Action chosen by default policy is not within valid range.");
                }
                if (currentBag == chosenBag) {
                    chosenAction = actionFromBag;
                }
                actionsSelected[actionFromBag - 1] = actionsSelected[actionFromBag - 1] + 1;
            }
            actionProbability = (float)actionsSelected[chosenAction - 1] / (float)this.policies.size();
        } else {
            chosenAction = this.policies.get(0).chooseAction(context);
            actionProbability = 1.0f;
        }
        return new DecisionTuple(chosenAction, actionProbability, true);
    }

    @Override
    public void enableExplore(boolean explore) {
        this.explore = explore;
    }
}

